/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.exception;

import jakarta.servlet.http.HttpServletRequest;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import tv.hd3g.authkit.mod.exception.SecurityRejectedRequestException;
import tv.hd3g.authkit.mod.service.AuditReportService;

public class UnauthorizedRequestException
extends SecurityRejectedRequestException {
    public UnauthorizedRequestException(String logMessage) {
        super(logMessage, HttpStatus.UNAUTHORIZED);
    }

    public UnauthorizedRequestException(String logMessage, String userUUID) {
        super(logMessage, HttpStatus.UNAUTHORIZED, UUID.fromString(userUUID));
    }

    @Override
    public void pushAudit(AuditReportService auditService, HttpServletRequest request) {
        auditService.interceptUnauthorizedRequest(request);
    }
}

