/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotEmpty;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import tv.hd3g.authkit.mod.entity.BaseEntity;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.Group;

@Entity
@Table(name="user")
public class User
extends BaseEntity {
    @NotEmpty
    @Column(length=38)
    private String uuid;
    @OneToOne(mappedBy="user", optional=true, fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    private Credential credential;
    @ManyToMany(cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.REFRESH, CascadeType.PERSIST})
    @JoinTable(name="usergroup", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="group_id")})
    private final Set<Group> groups = new HashSet<Group>();

    public User() {
    }

    public User(UUID uuid) {
        this.initCreate();
        this.uuid = uuid.toString();
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public Credential getCredential() {
        return this.credential;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }
}

