/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.entity;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.type.NumericBooleanConverter;
import tv.hd3g.authkit.mod.entity.BaseEntity;
import tv.hd3g.authkit.mod.entity.Totpbackupcode;
import tv.hd3g.authkit.mod.entity.User;

@Entity
@Table(name="credential")
public class Credential
extends BaseEntity {
    @NotBlank
    @Column(length=80)
    private String login;
    @NotNull
    @Lob
    @Column(nullable=false, columnDefinition="blob")
    private byte[] passwordhash;
    @NotBlank
    @Column(length=80)
    private String realm;
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(columnDefinition="TINYINT")
    private boolean enabled;
    @Lob
    @Column(nullable=true, columnDefinition="blob")
    private byte[] totpkey;
    @Column(length=80)
    private String ldapdomain;
    @OneToMany(mappedBy="credential", fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    private final Set<Totpbackupcode> totpBackupCodes = new HashSet<Totpbackupcode>();
    @OneToOne(optional=false, fetch=FetchType.LAZY, cascade={CascadeType.DETACH})
    @JoinColumn(name="user_id", nullable=false)
    private User user;
    @NotNull
    @Convert(converter=NumericBooleanConverter.class)
    @Column(columnDefinition="TINYINT")
    private boolean mustchangepassword;
    private Date lastlogin;
    @NotNull
    private short logontrial;

    public Credential() {
    }

    public Credential(User user, String login, byte[] passwordhash, String realm, boolean enabled, boolean mustchangepassword) {
        this.initCreate();
        this.user = user;
        this.login = login;
        this.passwordhash = passwordhash;
        this.realm = realm;
        this.enabled = enabled;
        this.mustchangepassword = mustchangepassword;
        this.logontrial = 0;
    }

    public Credential(User user, String login, String ldapdomain, String realm, boolean enabled) {
        this.initCreate();
        this.user = user;
        this.login = login;
        this.ldapdomain = ldapdomain;
        this.realm = realm;
        this.enabled = enabled;
        this.mustchangepassword = false;
        this.passwordhash = new byte[0];
        this.logontrial = 0;
    }

    public User getUser() {
        return this.user;
    }

    public String getLogin() {
        return this.login;
    }

    public String getRealm() {
        return this.realm;
    }

    public byte[] getPasswordhash() {
        return this.passwordhash;
    }

    public void setPasswordhash(byte[] passwordhash) {
        this.passwordhash = passwordhash;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public byte[] getTotpkey() {
        return this.totpkey;
    }

    public void setTotpkey(byte[] totpkey) {
        this.totpkey = totpkey;
    }

    public Set<Totpbackupcode> getTotpBackupCodes() {
        return this.totpBackupCodes;
    }

    public boolean isMustchangepassword() {
        return this.mustchangepassword;
    }

    public void setMustchangepassword(boolean mustchangepassword) {
        this.mustchangepassword = mustchangepassword;
    }

    public void setLastlogin(Date lastlogin) {
        this.lastlogin = lastlogin;
    }

    public Date getLastlogin() {
        return this.lastlogin;
    }

    public void setLogontrial(int logontrial) {
        this.logontrial = (short)logontrial;
    }

    public short getLogontrial() {
        return this.logontrial;
    }

    public String getLdapdomain() {
        return this.ldapdomain;
    }

    public void setLdapdomain(String ldapdomain) {
        this.ldapdomain = ldapdomain;
    }
}

