/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.dto.ressource;

import jakarta.validation.constraints.Size;
import java.util.Date;
import java.util.function.Function;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import tv.hd3g.authkit.mod.dto.ExternalAuthUserDto;
import tv.hd3g.authkit.mod.entity.Userprivacy;

public class UserPrivacyDto
extends RepresentationModel<UserPrivacyDto> {
    @Nullable
    private Date created;
    @Nullable
    private String userUUID;
    @Nullable
    private String name;
    @Nullable
    private String address;
    @Nullable
    @Size(max=16)
    private @Size(max=16) String postalcode;
    @Nullable
    @Size(max=3)
    private @Size(max=3) String country;
    @Nullable
    @Size(max=3)
    private @Size(max=3) String lang;
    @Nullable
    private String email;
    @Nullable
    @Size(max=128)
    private @Size(max=128) String company;
    @Nullable
    private String phone;

    public UserPrivacyDto() {
    }

    public UserPrivacyDto(Userprivacy user, Function<byte[], String> unCipher) {
        this.created = user.getCreated();
        this.userUUID = user.getUserUUID();
        this.name = unCipher.apply(user.getName());
        this.address = unCipher.apply(user.getAddress());
        this.postalcode = user.getPostalcode();
        this.country = user.getCountry();
        this.lang = user.getLang();
        this.email = unCipher.apply(user.getEmail());
        this.company = user.getCompany();
        this.phone = unCipher.apply(user.getPhone());
    }

    public UserPrivacyDto(ExternalAuthUserDto importFromLDAP) {
        if (importFromLDAP.getUserLongName() != null) {
            this.name = importFromLDAP.getUserLongName();
        }
        if (importFromLDAP.getUserEmail() != null) {
            this.email = importFromLDAP.getUserEmail();
        }
    }

    public void mergue(Userprivacy user, Function<String, byte[]> cipher) {
        if (this.name != null) {
            user.setName(cipher.apply(this.name));
        }
        if (this.address != null) {
            user.setAddress(cipher.apply(this.address));
        }
        if (this.postalcode != null) {
            user.setPostalcode(this.postalcode);
        }
        if (this.country != null) {
            user.setCountry(this.country);
        }
        if (this.lang != null) {
            user.setLang(this.lang);
        }
        if (this.email != null) {
            user.setEmail(cipher.apply(this.email));
        }
        if (this.company != null) {
            user.setCompany(this.company);
        }
        if (this.phone != null) {
            user.setPhone(cipher.apply(this.phone));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserPrivacyDto)) {
            return false;
        }
        UserPrivacyDto other = (UserPrivacyDto)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Date this$created = this.getCreated();
        Date other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$userUUID = this.getUserUUID();
        String other$userUUID = other.getUserUUID();
        if (this$userUUID == null ? other$userUUID != null : !this$userUUID.equals(other$userUUID)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        String this$postalcode = this.getPostalcode();
        String other$postalcode = other.getPostalcode();
        if (this$postalcode == null ? other$postalcode != null : !this$postalcode.equals(other$postalcode)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$company = this.getCompany();
        String other$company = other.getCompany();
        if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
            return false;
        }
        String this$phone = this.getPhone();
        String other$phone = other.getPhone();
        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserPrivacyDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Date $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $userUUID = this.getUserUUID();
        result = result * 59 + ($userUUID == null ? 43 : $userUUID.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        String $postalcode = this.getPostalcode();
        result = result * 59 + ($postalcode == null ? 43 : $postalcode.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $company = this.getCompany();
        result = result * 59 + ($company == null ? 43 : $company.hashCode());
        String $phone = this.getPhone();
        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
        return result;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getUserUUID() {
        return this.userUUID;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getAddress() {
        return this.address;
    }

    @Nullable
    public String getPostalcode() {
        return this.postalcode;
    }

    @Nullable
    public String getCountry() {
        return this.country;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Nullable
    public String getCompany() {
        return this.company;
    }

    @Nullable
    public String getPhone() {
        return this.phone;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public void setAddress(@Nullable String address) {
        this.address = address;
    }

    public void setPostalcode(@Nullable String postalcode) {
        this.postalcode = postalcode;
    }

    public void setCountry(@Nullable String country) {
        this.country = country;
    }

    public void setLang(@Nullable String lang) {
        this.lang = lang;
    }

    public void setEmail(@Nullable String email) {
        this.email = email;
    }

    public void setCompany(@Nullable String company) {
        this.company = company;
    }

    public void setPhone(@Nullable String phone) {
        this.phone = phone;
    }
}

