/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.dto;

import de.mkammerer.argon2.Argon2;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import tv.hd3g.authkit.mod.exception.PasswordComplexityException;

public class Password
implements CharSequence {
    private final char[] value;
    private static final String REUSE_ERROR = "You can't reuse a Password object";
    private static final Set<Integer> specialCharList = Stream.of((byte)23, (byte)26, (byte)20, (byte)7, (byte)22, (byte)30, (byte)29, (byte)25, (byte)27, (byte)24, (byte)28, (byte)21).map(b -> (int)b).collect(Collectors.toSet());

    public Password(CharSequence value) {
        Objects.requireNonNull(value, "Can't handle null passwords");
        if (value.length() == 0) {
            throw new IllegalArgumentException("Can't handle empty passwords");
        }
        this.value = new char[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            this.value[i] = value.charAt(i);
        }
    }

    @Override
    public String toString() {
        return StringUtils.repeat((String)"*", (int)this.value.length);
    }

    @Override
    public int length() {
        return this.value.length;
    }

    @Override
    public char charAt(int index) {
        if (index >= this.value.length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        char current = this.value[index];
        if (current == '\u0000') {
            throw new IndexOutOfBoundsException("Index: " + index + " was read, empty value now");
        }
        return current;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (this.value[start] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            sb.append(this.charAt(i));
        }
        return sb;
    }

    public void reset() {
        Arrays.fill(this.value, '\u0000');
    }

    public boolean verify(Argon2 argon2, String passwordHash) {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        boolean result = argon2.verify(passwordHash, this.value);
        this.reset();
        return result;
    }

    public String hash(Function<char[], String> hasher) {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        String result = hasher.apply(this.value);
        this.reset();
        return result;
    }

    public Password duplicate() {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        return new Password(this.subSequence(0, this.value.length));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Password other = (Password)obj;
        return Arrays.equals(this.value, other.value);
    }

    public static boolean equalsInsensitive(char[] l, char[] r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        return Password.equalsInsensitive(l, 0, l.length, r, 0, r.length);
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static boolean equalsInsensitive(char[] l, int lFromIndex, int lToIndex, char[] r, int rFromIndex, int rToIndex) {
        Password.rangeCheck(l.length, lFromIndex, lToIndex);
        Password.rangeCheck(r.length, rFromIndex, rToIndex);
        int aLength = lToIndex - lFromIndex;
        int bLength = rToIndex - rFromIndex;
        if (aLength != bLength) {
            return false;
        }
        char[] l2 = Arrays.copyOf(l, l.length);
        for (int pos = 0; pos < l2.length; ++pos) {
            l2[pos] = Character.toUpperCase(l2[pos]);
        }
        char[] r2 = Arrays.copyOf(r, r.length);
        for (int pos = 0; pos < r2.length; ++pos) {
            r2[pos] = Character.toUpperCase(r2[pos]);
        }
        boolean result = Arrays.equals(l2, lFromIndex, lToIndex, r2, rFromIndex, rToIndex);
        Arrays.fill(l2, '\u0000');
        Arrays.fill(r2, '\u0000');
        return result;
    }

    public static boolean containCharArray(char[] term, char[] value) {
        if (term.length == 0 || value.length == 0) {
            return false;
        }
        if (value.length < term.length) {
            return false;
        }
        if (Password.equalsInsensitive(value, term)) {
            return true;
        }
        for (int pos = 0; pos < value.length - term.length + 1; ++pos) {
            if (!Password.equalsInsensitive(value, pos, pos + term.length, term, 0, term.length)) continue;
            return true;
        }
        return false;
    }

    public boolean contain(String term) {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        return Password.containCharArray(term.toCharArray(), this.value);
    }

    public void checkComplexity(int minSize, boolean mustHaveSpecialChars, String genericTermPresenceToIgnore) throws PasswordComplexityException {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        if (this.value.length < minSize) {
            throw new PasswordComplexityException.PasswordTooShortException("Proposed password is too short");
        }
        char[] term = genericTermPresenceToIgnore.toCharArray();
        if (term == null) {
            this.checkComplexity(minSize, mustHaveSpecialChars);
            return;
        }
        if (Password.equalsInsensitive(this.value, term)) {
            throw new PasswordComplexityException.PasswordTooSimpleException("Proposed password is a too generic term");
        }
        int newLen = this.value.length - term.length;
        char[] valueToTest = new char[newLen];
        for (int pos = 0; pos < newLen + 1; ++pos) {
            if (!Password.equalsInsensitive(this.value, pos, pos + term.length, term, 0, term.length)) continue;
            if (pos == 0) {
                System.arraycopy(this.value, term.length, valueToTest, 0, newLen);
            } else if (pos == this.value.length - term.length) {
                System.arraycopy(this.value, 0, valueToTest, 0, newLen);
            } else {
                System.arraycopy(this.value, 0, valueToTest, 0, pos + 1);
                System.arraycopy(this.value, pos + term.length, valueToTest, pos, newLen - pos);
            }
            Password.checkSomeComplexity(minSize, mustHaveSpecialChars, valueToTest);
        }
    }

    public static void checkSomeComplexity(int minSize, boolean mustHaveSpecialChars, char[] value) throws PasswordComplexityException {
        if (IntStream.range(0, value.length).mapToObj(i -> Character.valueOf(value[i])).noneMatch(Character::isLowerCase) || IntStream.range(0, value.length).mapToObj(i -> Character.valueOf(value[i])).noneMatch(Character::isUpperCase)) {
            throw new PasswordComplexityException.PasswordTooSimpleException("Proposed password don't mix upper and lower case");
        }
        long lenWOSpaces = IntStream.range(0, value.length).mapToObj(i -> Character.valueOf(value[i])).filter(ch -> !Character.isSpaceChar(ch.charValue())).count();
        if (lenWOSpaces < (long)minSize) {
            throw new PasswordComplexityException.PasswordTooShortException("Spaces in proposed password are not counted for length validation constraint");
        }
        char[] valueWOSpaces = new char[(int)lenWOSpaces];
        int posValueWOSpaces = 0;
        for (char element : value) {
            if (Character.isSpaceChar(element)) continue;
            valueWOSpaces[posValueWOSpaces++] = element;
        }
        if (mustHaveSpecialChars) {
            boolean specialCharsPresence = IntStream.range(0, valueWOSpaces.length).mapToObj(i -> Character.valueOf(valueWOSpaces[i])).map(Character::getType).anyMatch(specialCharList::contains);
            if (!specialCharsPresence) {
                Arrays.fill(valueWOSpaces, '\u0000');
                throw new PasswordComplexityException.PasswordTooSimpleException("Proposed password must at least include a special char, for this specific account.");
            }
        }
        if (Password.containCharArray(valueWOSpaces, "abcdefghijklmnopqrstuvwxyz".toCharArray()) || Password.containCharArray(valueWOSpaces, "qwertyuiopasdfghjklzxcvbnm".toCharArray()) || Password.containCharArray(valueWOSpaces, "azertyuiopqsdfghjklmwxcvbn".toCharArray())) {
            Arrays.fill(valueWOSpaces, '\u0000');
            throw new PasswordComplexityException.PasswordTooSimpleException("Proposed password can't include a too simple abcdef/qwerty string sequence.");
        }
    }

    public void checkComplexity(int minSize, boolean mustHaveSpecialChars) throws PasswordComplexityException {
        if (this.value[0] == '\u0000') {
            throw new IllegalStateException(REUSE_ERROR);
        }
        if (this.value.length < minSize) {
            throw new PasswordComplexityException.PasswordTooShortException("Proposed password is too short");
        }
        char[] valueToTest = new char[this.value.length];
        System.arraycopy(this.value, 0, valueToTest, 0, this.value.length);
        Password.checkSomeComplexity(minSize, mustHaveSpecialChars, valueToTest);
    }
}

