/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.controller;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import org.owasp.encoder.Encode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.dto.ressource.IsExternalAuthDto;
import tv.hd3g.authkit.mod.dto.ressource.IsTOTPEnabledDto;
import tv.hd3g.authkit.mod.dto.ressource.SetupTOTPDto;
import tv.hd3g.authkit.mod.dto.ressource.UserPrivacyDto;
import tv.hd3g.authkit.mod.dto.validated.ChangeMyPasswordDto;
import tv.hd3g.authkit.mod.dto.validated.ValidationSetupTOTPDto;
import tv.hd3g.authkit.mod.dto.validated.ValidationTOTPDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.exception.BlockedUserException;
import tv.hd3g.authkit.mod.exception.ResetWithSamePasswordException;
import tv.hd3g.authkit.mod.repository.CredentialRepository;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.authkit.mod.service.TOTPService;
import tv.hd3g.commons.authkit.AuditAfter;

@RestController
@RequestMapping(value={"/v1/authkit/me"}, produces={"application/json"})
public class RestControllerMe {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private CredentialRepository credentialRepository;
    @Autowired
    private TOTPService totpService;
    @Autowired
    private SecuredTokenService securedTokenService;
    @Value(value="${authkit.maxTOTPSetupTime:20m}")
    private Duration expirationDuration;

    private String getCurrentUserUUID(HttpServletRequest request) {
        return ControllerInterceptor.getRequestUserUUID(request).orElseThrow(() -> new AuthKitException(401, "You must be connected before."));
    }

    private Credential getCurrentUserCredential(String userUUID) {
        return Optional.ofNullable(this.credentialRepository.getByUserUUID(userUUID)).orElseThrow(() -> new AuthKitException(401, "Can't found you're user account."));
    }

    @Transactional(readOnly=false)
    @PostMapping(value={"chpasswd"})
    @AuditAfter(value="changeMyPassword", changeSecurity=true)
    public ResponseEntity<Object> changeMyPassword(@RequestBody @Validated ChangeMyPasswordDto chPasswordDto, HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        if (credential.getLdapdomain() != null) {
            throw new AuthKitException("You can't change the password here for an external authentication");
        }
        Optional<AuditReportService.RejectLoginCause> checkResultFail = this.authenticationService.checkPassword(chPasswordDto.getCurrentpassword(), credential);
        if (checkResultFail.isPresent()) {
            throw new AuthKitException("Actual provided password is invalid: " + (Object)((Object)checkResultFail.get()));
        }
        if (credential.getTotpkey() != null) {
            this.authenticationService.checkCodeAndPassword(credential, chPasswordDto);
        }
        try {
            this.authenticationService.changeUserPassword(userUUID, chPasswordDto.getNewpassword());
        }
        catch (ResetWithSamePasswordException e) {
            throw new AuthKitException("You can't change a password with the same");
        }
        catch (BlockedUserException e) {
            throw new AuthKitException("You can't change the password for a blocked account");
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"is-external-auth"})
    public ResponseEntity<IsExternalAuthDto> isExternalAuth(HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        IsExternalAuthDto result = new IsExternalAuthDto(credential);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"set2auth"})
    public ResponseEntity<SetupTOTPDto> prepareTOTP(HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        if (credential.getTotpkey() != null) {
            throw new AuthKitException("2auth was previouly setup: please cancel it before setup a second time.");
        }
        String secret = this.totpService.makeSecret();
        URI totpURI = this.totpService.makeURI(secret, credential.getUser(), Encode.forJavaScript((String)request.getServerName()));
        String qrcode = this.totpService.makeQRCode(totpURI);
        List<String> backupCodes = this.totpService.makeBackupCodes();
        String jwtControl = this.securedTokenService.setupTOTPGenerateToken(userUUID, this.expirationDuration, secret, backupCodes);
        SetupTOTPDto result = new SetupTOTPDto(secret, totpURI, qrcode, backupCodes, jwtControl);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PostMapping(value={"set2auth"})
    @AuditAfter(value="setTOTP", changeSecurity=true)
    public ResponseEntity<Object> confirmTOTP(@RequestBody @Validated ValidationSetupTOTPDto setupDto, HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        if (credential.getTotpkey() != null) {
            throw new AuthKitException("2auth was previouly setup: please cancel it before setup a second time.");
        }
        this.authenticationService.setupTOTPWithChecks(setupDto, userUUID);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"has2auth"})
    public ResponseEntity<IsTOTPEnabledDto> hasATOTP(HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        IsTOTPEnabledDto result = new IsTOTPEnabledDto(credential);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @DeleteMapping(value={"set2auth"})
    @AuditAfter(value="setTOTP", changeSecurity=true)
    public ResponseEntity<Object> removeTOTP(@RequestBody @Validated ValidationTOTPDto validationDto, HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        Credential credential = this.getCurrentUserCredential(userUUID);
        if (credential.getTotpkey() == null) {
            throw new AuthKitException("2auth was not setup.");
        }
        this.authenticationService.checkCodeAndPassword(credential, validationDto);
        this.totpService.removeTOTP(credential);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"privacy"})
    @AuditAfter(value="getPrivacy", changeSecurity=false)
    public ResponseEntity<UserPrivacyDto> getPrivacy(HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        List<UserPrivacyDto> list = this.authenticationService.getUserPrivacyList(List.of(userUUID));
        UserPrivacyDto result = list.isEmpty() ? new UserPrivacyDto() : list.get(0);
        return new ResponseEntity((Object)result, (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"privacy"})
    @AuditAfter(value="setPrivacy", changeSecurity=true)
    public ResponseEntity<Object> setPrivacy(@RequestBody @Validated UserPrivacyDto userPrivacyDto, HttpServletRequest request) {
        String userUUID = this.getCurrentUserUUID(request);
        this.authenticationService.setUserPrivacy(userUUID, userPrivacyDto);
        return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
    }
}

