/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.exception.SecurityRejectedRequestException;
import tv.hd3g.authkit.mod.exception.UnauthorizedRequestException;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuditReportServiceImpl;
import tv.hd3g.authkit.mod.service.CookieService;
import tv.hd3g.authkit.utility.ControllerType;

public class SecurityRejectedRequestMappingExceptionResolver
extends SimpleMappingExceptionResolver {
    private static final Logger log = LogManager.getLogger();
    private final AuditReportService auditService;
    private final CookieService cookieService;
    private final String authErrorViewName;

    public SecurityRejectedRequestMappingExceptionResolver(AuditReportService auditService, CookieService cookieService, String authErrorViewName) {
        this.auditService = auditService;
        this.cookieService = cookieService;
        this.authErrorViewName = authErrorViewName;
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception e) {
        Object controllerTypeObject = request.getAttribute(ControllerInterceptor.CONTROLLER_TYPE_ATTRIBUTE_NAME);
        if (controllerTypeObject == null) {
            if (log.isTraceEnabled()) {
                log.trace("{} request exception ({}) is not managed here (controllerType is not set)", (Object)request.getRequestURI(), e.getClass());
            }
            return null;
        }
        if (!(e instanceof SecurityRejectedRequestException)) {
            if (log.isTraceEnabled()) {
                log.trace("{} request exception ({}) is not managed here", (Object)request.getRequestURI(), e.getClass());
            }
            return null;
        }
        ControllerType controllerType = (ControllerType)((Object)controllerTypeObject);
        SecurityRejectedRequestException requestException = (SecurityRejectedRequestException)e;
        HttpStatus statusCode = requestException.getStatusCode();
        String addr = AuditReportServiceImpl.getOriginalRemoteAddr(request);
        UUID userUUID = requestException.getUserUUID();
        if (userUUID != null) {
            log.warn("[{} {}] {}; {}", (Object)addr, (Object)request.getRequestURI(), (Object)e.getMessage(), (Object)userUUID);
        } else {
            log.warn("[{} {}] {}", (Object)addr, (Object)request.getRequestURI(), (Object)e.getMessage());
        }
        requestException.pushAudit(this.auditService, request);
        if (controllerType == ControllerType.CLASSIC) {
            if (requestException instanceof UnauthorizedRequestException) {
                String redirectURL = SecurityRejectedRequestMappingExceptionResolver.removeSpecialChars(request.getRequestURI() + Optional.ofNullable(request.getQueryString()).map("?"::concat).orElse(""));
                Cookie cookieRedirect = this.cookieService.createRedirectAfterLoginCookie(redirectURL);
                cookieRedirect.setSecure(true);
                response.addCookie(cookieRedirect);
            }
            ModelAndView mav = new ModelAndView(this.authErrorViewName);
            mav.addObject("cause", (Object)statusCode.value());
            mav.addObject("requestURL", (Object)request.getRequestURL().toString());
            mav.addObject("isnotlogged", (Object)ControllerInterceptor.getUserTokenFromRequestAttribute(request).isEmpty());
            mav.setStatus((HttpStatusCode)statusCode);
            return mav;
        }
        if (controllerType == ControllerType.REST) {
            try {
                response.sendError(statusCode.value());
            }
            catch (IOException e1) {
                log.error("Can't send error response", (Throwable)e1);
            }
        }
        return new ModelAndView();
    }

    static String removeSpecialChars(String str) {
        StringBuilder sb = new StringBuilder();
        for (int pos = 0; pos < str.length(); ++pos) {
            int currChar = str.codePointAt(pos);
            if (Character.isSpaceChar(currChar) || Character.isWhitespace(currChar)) continue;
            sb.append(str.charAt(pos));
        }
        return sb.toString();
    }
}

