/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import tv.hd3g.authkit.mod.component.AuthKitEndpointsListener;
import tv.hd3g.authkit.mod.dto.LoggedUserTagsTokenDto;
import tv.hd3g.authkit.mod.exception.BadRequestException;
import tv.hd3g.authkit.mod.exception.ForbiddenRequestException;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.exception.UnauthorizedRequestException;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuditReportServiceImpl;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.CookieService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.authkit.utility.AnnotatedControllerClass;
import tv.hd3g.authkit.utility.ControllerType;
import tv.hd3g.authkit.utility.LogSanitizer;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.CheckBefore;

public class ControllerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LogManager.getLogger();
    private static final String PACKAGE_NAME = ControllerInterceptor.class.getPackageName();
    public static final String USER_UUID_ATTRIBUTE_NAME = PACKAGE_NAME + ".userUUID";
    public static final String USER_TOKEN_ATTRIBUTE_NAME = PACKAGE_NAME + ".LoggedUserTagsToken";
    public static final String CONTROLLER_TYPE_ATTRIBUTE_NAME = PACKAGE_NAME + ".controllerType";
    public static final String REDIRECT_AFTER_LOGIN_ATTRIBUTE_NAME = PACKAGE_NAME + ".redirectAfterLogin";
    private final AuditReportService auditService;
    private final SecuredTokenService securedTokenService;
    private final AuthKitEndpointsListener authKitEndpointsListener;
    private final AuthenticationService authenticationService;
    private final CookieService cookieService;

    public ControllerInterceptor(AuditReportService auditService, SecuredTokenService securedTokenService, AuthKitEndpointsListener authKitEndpointsListener, AuthenticationService authenticationService, CookieService cookieService) {
        this.auditService = auditService;
        this.securedTokenService = securedTokenService;
        this.authKitEndpointsListener = authKitEndpointsListener;
        this.authenticationService = authenticationService;
        this.cookieService = cookieService;
    }

    private boolean isRequestIsHandle(HttpServletRequest request, Object handler) {
        if (handler instanceof ResourceHttpRequestHandler) {
            ResourceHttpRequestHandler httpHandler = (ResourceHttpRequestHandler)handler;
            Optional.ofNullable(httpHandler.getUrlPathHelper()).map(uph -> uph.getLookupPathForRequest(request)).ifPresent(h -> log.trace("HandlerH: {}", h));
            return false;
        }
        if (!(handler instanceof HandlerMethod)) {
            log.info("Unknown handler: {}", handler.getClass());
            return false;
        }
        return true;
    }

    private Optional<LoggedUserTagsTokenDto> extractAndCheckAuthToken(HttpServletRequest request) {
        LoggedUserTagsTokenDto loggedDto;
        Optional<String> oBearer = Optional.ofNullable(request.getHeader("Authorization")).filter(content -> content.toLowerCase().startsWith("bearer")).map(content -> content.substring("bearer".length()).trim());
        boolean fromCookie = false;
        if (oBearer.isEmpty()) {
            oBearer = Optional.ofNullable(this.cookieService.getLogonCookiePayload(request));
            fromCookie = true;
        }
        if (oBearer.isEmpty()) {
            return Optional.empty();
        }
        try {
            loggedDto = Objects.requireNonNull(this.securedTokenService.loggedUserRightsExtractToken(oBearer.get(), fromCookie));
        }
        catch (NotAcceptableSecuredTokenException e) {
            throw new UnauthorizedRequestException("Invalid JWT in auth request");
        }
        if (loggedDto.getOnlyForHost() != null) {
            InetAddress addr2;
            InetAddress addr1;
            try {
                addr1 = InetAddress.getByName(loggedDto.getOnlyForHost());
                addr2 = InetAddress.getByName(AuditReportServiceImpl.getOriginalRemoteAddr(request));
            }
            catch (UnknownHostException e) {
                addr1 = null;
                addr2 = null;
            }
            if (addr1 == null || !addr1.equals(addr2)) {
                throw new UnauthorizedRequestException("Reject request for from " + loggedDto.getOnlyForHost() + " because the actual token contain a IP restriction on {} only", loggedDto.getUserUUID());
            }
        }
        return Optional.ofNullable(loggedDto);
    }

    private void compareUserRightsAndRequestMandatories(HttpServletRequest request, LoggedUserTagsTokenDto loggedUserTagsTokenDto, Method classMethod, AnnotatedControllerClass annotatedControllerClass) {
        String userUUID;
        List<CheckBefore> requireAuthList = annotatedControllerClass.getRequireAuthList(classMethod);
        if (requireAuthList.isEmpty() && !annotatedControllerClass.isRequireValidAuth(classMethod)) {
            return;
        }
        if (loggedUserTagsTokenDto.isFromCookie()) {
            if (annotatedControllerClass.getControllerType().equals((Object)ControllerType.REST)) {
                throw new UnauthorizedRequestException("An auth cookie can't authorized a REST request");
            }
            String requestVerb = request.getMethod();
            if (!requestVerb.equalsIgnoreCase("GET") && !requestVerb.equalsIgnoreCase("POST")) {
                throw new BadRequestException("Unacceptable method " + requestVerb);
            }
        }
        if ((userUUID = loggedUserTagsTokenDto.getUserUUID()) == null) {
            throw new UnauthorizedRequestException("Unauthorized");
        }
        if (requireAuthList.stream().noneMatch(annotation -> Arrays.stream(annotation.value()).allMatch(loggedUserTagsTokenDto.getTags()::contains))) {
            throw new ForbiddenRequestException("Forbidden user", userUUID);
        }
    }

    private void checkRenforcedRightsChecks(HttpServletRequest request, AnnotatedControllerClass annotatedControllerClass, Method classMethod, LoggedUserTagsTokenDto tokenPayload) {
        if (!annotatedControllerClass.isRequireRenforceCheckBefore(classMethod)) {
            return;
        }
        String userUUID = tokenPayload.getUserUUID();
        if (!this.authenticationService.isUserEnabledAndNonBlocked(userUUID)) {
            throw new UnauthorizedRequestException("User {} is now disabled/blocked before last login", userUUID);
        }
        String clientAddr = AuditReportServiceImpl.getOriginalRemoteAddr(request);
        Set actualTags = this.authenticationService.getRightsForUser(userUUID, clientAddr).stream().distinct().collect(Collectors.toUnmodifiableSet());
        for (String tag : tokenPayload.getTags()) {
            if (actualTags.contains(tag)) continue;
            throw new ForbiddenRequestException("User has lost some rights (like " + tag + ") before last login", userUUID);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (!this.isRequestIsHandle(request, handler)) {
            return true;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class controllerClass = handlerMethod.getBeanType();
        AnnotatedControllerClass annotatedClass = this.authKitEndpointsListener.getAnnotatedClass(controllerClass);
        Method classMethod = handlerMethod.getMethod();
        request.setAttribute(CONTROLLER_TYPE_ATTRIBUTE_NAME, (Object)annotatedClass.getControllerType());
        Optional<LoggedUserTagsTokenDto> oTokenPayload = this.extractAndCheckAuthToken(request);
        if (oTokenPayload.isPresent()) {
            request.setAttribute(USER_TOKEN_ATTRIBUTE_NAME, (Object)oTokenPayload.get());
        }
        LoggedUserTagsTokenDto tokenPayload = oTokenPayload.orElse(new LoggedUserTagsTokenDto(null, Set.of(), null, false));
        this.checkRenforcedRightsChecks(request, annotatedClass, classMethod, tokenPayload);
        this.compareUserRightsAndRequestMandatories(request, tokenPayload, classMethod, annotatedClass);
        String userUUID = tokenPayload.getUserUUID();
        request.setAttribute(USER_UUID_ATTRIBUTE_NAME, (Object)userUUID);
        Optional.ofNullable(this.cookieService.getRedirectAfterLoginCookiePayload(request)).ifPresent(redirectTo -> request.setAttribute(REDIRECT_AFTER_LOGIN_ATTRIBUTE_NAME, redirectTo));
        if (userUUID == null) {
            log.info("Request {} {}:{}()", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName());
        } else {
            log.info("Request {} {}:{}() {}", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName(), (Object)userUUID);
        }
        return true;
    }

    public static final Optional<String> getRequestUserUUID(HttpServletRequest request) {
        return Optional.ofNullable(request.getAttribute(USER_UUID_ATTRIBUTE_NAME)).map(o -> LogSanitizer.sanitize((String)o));
    }

    public static final Optional<LoggedUserTagsTokenDto> getUserTokenFromRequestAttribute(HttpServletRequest request) {
        return Optional.ofNullable(request.getAttribute(USER_TOKEN_ATTRIBUTE_NAME)).map(LoggedUserTagsTokenDto.class::cast);
    }

    public static final Optional<String> getPathToRedirectToAfterLogin(HttpServletRequest request) {
        return Optional.ofNullable(request.getAttribute(REDIRECT_AFTER_LOGIN_ATTRIBUTE_NAME)).map(o -> LogSanitizer.sanitize((String)o));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        List<String> namesSimpleAudit;
        List<String> namesUseSecurity;
        Method classMethod;
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class controllerClass = handlerMethod.getBeanType();
        AnnotatedControllerClass annotatedClass = this.authKitEndpointsListener.getAnnotatedClass(controllerClass);
        List<AuditAfter> auditList = annotatedClass.getAudits(classMethod = handlerMethod.getMethod());
        if (auditList.isEmpty()) {
            return;
        }
        Optional.ofNullable(exception).ifPresent(e -> {
            List<String> names = auditList.stream().filter(AuditAfter::cantDoErrors).map(AuditAfter::value).toList();
            if (!names.isEmpty()) {
                this.auditService.onImportantError(request, names, (Exception)e);
            }
        });
        List<String> namesChangeSecurity = auditList.stream().filter(AuditAfter::changeSecurity).map(AuditAfter::value).toList();
        if (!namesChangeSecurity.isEmpty()) {
            this.auditService.onChangeSecurity(request, namesChangeSecurity);
        }
        if (!(namesUseSecurity = auditList.stream().filter(AuditAfter::useSecurity).map(AuditAfter::value).toList()).isEmpty()) {
            this.auditService.onUseSecurity(request, namesUseSecurity);
        }
        if (!(namesSimpleAudit = auditList.stream().filter(audit -> !audit.cantDoErrors() && !audit.changeSecurity() && !audit.useSecurity()).map(AuditAfter::value).toList()).isEmpty()) {
            this.auditService.onSimpleEvent(request, namesSimpleAudit);
        }
    }
}

