/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.reference.DefaultEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.config.ExternalLDAP;
import tv.hd3g.authkit.mod.dto.ExternalAuthUserDto;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.service.ExternalAuthClientService;

@Service
public class ExternalAuthClientLDAPServiceImpl
implements ExternalAuthClientService {
    private static Logger log = LogManager.getLogger();
    private static final Encoder encoder;
    @Autowired
    private ExternalLDAP externalLDAP;
    private static final UnaryOperator<String> extractOrganizationalUnits;

    @Override
    public boolean isAvailable() {
        return this.externalLDAP != null && this.externalLDAP.isAvailable();
    }

    private ExternalLDAP.LDAPEntry getConfiguration(String domain) {
        Optional<ExternalLDAP.LDAPEntry> oLDAPEntry = this.externalLDAP.getByDomainName(domain);
        if (oLDAPEntry.isEmpty()) {
            log.error("Can't found configuration for {} domain", (Object)domain);
            throw new AuthKitException(500, "Can't login");
        }
        return oLDAPEntry.get();
    }

    @Override
    public ExternalAuthUserDto logonUser(String unProtectedlogin, Password password, String unProtectedDomain) throws UserCantLoginException {
        String domain = encoder.encodeForDN(unProtectedDomain);
        String login = encoder.encodeForLDAP(unProtectedlogin);
        if (!this.isAvailable()) {
            throw new UserCantLoginException.ExternalAuthErrorCantLoginException();
        }
        if (password == null || password.length() == 0) {
            throw new UserCantLoginException.NoPasswordUserCantLoginException();
        }
        if (!StringUtils.isAlphanumeric((CharSequence)domain) || !StringUtils.isAlphanumeric((CharSequence)login)) {
            throw new IllegalArgumentException("Login or domain invalid");
        }
        ExternalLDAP.LDAPEntry configuration = this.getConfiguration(domain);
        if (configuration.getType() != ExternalLDAP.LDAPType.AD) {
            throw new IllegalArgumentException("Unsuported LDAP typ server: " + configuration.getType());
        }
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("java.naming.security.principal", login + "@" + domain);
        props.put("java.naming.security.credentials", password.subSequence(0, password.length()).toString());
        props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        props.put("java.naming.provider.url", "ldap://" + configuration.getHost() + ":" + configuration.getPort() + "/");
        props.put("java.naming.ldap.attributes.binary", "tokenGroups");
        try {
            InitialLdapContext context = new InitialLdapContext(props, null);
            if (!((String)context.getEnvironment().get("java.naming.security.principal")).contains("@")) {
                throw new UserCantLoginException.UnknownUserCantLoginException();
            }
            SearchControls controls = new SearchControls();
            controls.setSearchScope(2);
            controls.setCountLimit(1L);
            controls.setTimeLimit(500);
            NamingEnumeration<SearchResult> answer = context.search(ExternalAuthClientLDAPServiceImpl.toDC(domain), configuration.getLdapSearchLogonQuery().replace("<ldapTenantName>", login), controls);
            if (!answer.hasMore()) {
                log.error("Can't get LDAP entry for {}", (Object)login);
                throw new UserCantLoginException.UnknownUserCantLoginException();
            }
            Attributes attr = answer.next().getAttributes();
            Attribute user = attr.get(configuration.getLdapTenantName());
            if (user == null) {
                log.error("Can't get LDAP user for {}", (Object)login);
                throw new UserCantLoginException.UnknownUserCantLoginException();
            }
            String userLongName = this.extractLDAPSearchResultVar(configuration.getLdapCommonName(), attr).orElseThrow(() -> new NamingException("Can't get LDAP user CN for " + login));
            String userEmail = this.extractLDAPSearchResultVar(configuration.getLdapMailName(), attr).orElse(null);
            List<String> memberOf = this.extractLDAPSearchResultVars("memberOf", attr).map(extractOrganizationalUnits).toList();
            return new ExternalAuthUserDto(login, domain, userLongName, userEmail, memberOf);
        }
        catch (CommunicationException e) {
            log.error("Failed to connect to {}: {}", (Object)configuration.getHost(), (Object)configuration.getPort(), (Object)e);
            throw new UserCantLoginException.ExternalAuthErrorCantLoginException();
        }
        catch (NamingException e) {
            log.error("Failed to authenticate {}@{} through {}", (Object)login, (Object)domain, (Object)configuration.getHost(), (Object)e);
            throw new UserCantLoginException.BadPasswordUserCantLoginException();
        }
    }

    private Optional<String> extractLDAPSearchResultVar(String key, Attributes attr) {
        Attribute item = attr.get(key);
        if (item == null) {
            return Optional.empty();
        }
        try {
            Object value = item.get();
            if (!(value instanceof String)) {
                return Optional.ofNullable(String.valueOf(value));
            }
            return Optional.ofNullable((String)value);
        }
        catch (NamingException e) {
            log.debug("Can't found {} in LDAP datas", (Object)key, (Object)e);
            return Optional.empty();
        }
    }

    private Stream<String> extractLDAPSearchResultVars(String key, Attributes attr) {
        Attribute item = attr.get(key);
        if (item == null) {
            return Stream.empty();
        }
        try {
            int size = item.size();
            return StreamSupport.stream(Spliterators.spliterator(item.getAll().asIterator(), (long)size, 16), false).map(value -> {
                if (!(value instanceof String)) {
                    return String.valueOf(value);
                }
                return (String)value;
            });
        }
        catch (NamingException e) {
            log.debug("Can't found {} in LDAP datas", (Object)key, (Object)e);
            return Stream.empty();
        }
    }

    private static String toDC(String domain) {
        return Arrays.stream(domain.split("\\.")).filter(entry -> !entry.isEmpty()).collect(Collectors.joining(",DC=", "DC=", ""));
    }

    @Override
    public Optional<String> getDefaultDomainName() {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.externalLDAP.getServers().get(0).getDomain());
    }

    @Override
    public boolean isIPAllowedToCreateUserAccount(InetAddress address, String domain) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.externalLDAP.getByDomainName(domain).map(entry -> entry.isAllowed(address)).orElse(false);
    }

    static {
        System.setProperty("org.owasp.esapi.logSpecial.discard", "true");
        encoder = DefaultEncoder.getInstance();
        extractOrganizationalUnits = ldapEntry -> {
            String[] entrySplited = ldapEntry.split(",");
            String commonName = Arrays.stream(entrySplited).filter(dn -> dn.toUpperCase().startsWith("CN=")).map(dn -> dn.substring(3)).collect(Collectors.joining());
            String organizationalUnits = Arrays.stream(entrySplited).filter(dn -> dn.toUpperCase().startsWith("OU=")).map(dn -> dn.substring(3)).collect(Collectors.joining("/", "/", ""));
            String domain = Arrays.stream(entrySplited).filter(dn -> dn.toUpperCase().startsWith("DC=")).map(dn -> dn.substring(3)).collect(Collectors.joining("."));
            return commonName + " (" + domain + organizationalUnits + ")";
        };
    }
}

