/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.service.CipherService;

@Service
public class CipherServiceImpl
implements CipherService {
    private static final String SHA3_512 = "SHA3-512";
    private static Logger log = LogManager.getLogger();
    private SecureRandom random;
    private final SecretKey secretKey;
    private final int ivSize;
    private final String transformation;
    private final int gCMParameterSpecLen;

    public CipherServiceImpl(@Value(value="${authkit.cipher_secret}") String base64secret, @Value(value="${authkit.cipher_ivsize:12}") int ivSize, @Value(value="${authkit.cipher_transformation:AES/GCM/NoPadding}") String transformation, @Value(value="${authkit.cipher_GCMParameterSpecLen:128}") int gCMParameterSpecLen) throws GeneralSecurityException {
        byte[] secret = Base64.getDecoder().decode(base64secret.getBytes(StandardCharsets.UTF_8));
        this.secretKey = new SecretKeySpec(secret, "AES");
        try {
            this.random = SecureRandom.getInstance("NATIVEPRNGNONBLOCKING");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = SecureRandom.getInstanceStrong();
        }
        this.ivSize = ivSize;
        this.transformation = transformation;
        this.gCMParameterSpecLen = gCMParameterSpecLen;
        log.debug(() -> "Init cipher with secret width=" + secret.length * 8 + " bits, ivSize=" + ivSize + ", transformation=" + transformation + ", GCMParameterSpecLen=" + gCMParameterSpecLen);
        try {
            String v = new String(this.internalUnCipher(this.internalCipher("check".getBytes(StandardCharsets.UTF_8))), StandardCharsets.UTF_8);
            if (!v.equals("check")) {
                throw new GeneralSecurityException("Invalid autotest result: " + v);
            }
        }
        catch (GeneralSecurityException e) {
            log.error("Can't do cipher self test, check JVM setup/key configuration", (Throwable)e);
            throw e;
        }
        try {
            MessageDigest.getInstance(SHA3_512);
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Init SHA-3 digest, check JVM setup/version", (Throwable)e);
            throw e;
        }
    }

    @Override
    public Random getSecureRandom() {
        return this.random;
    }

    private byte[] internalCipher(byte[] clearData) throws GeneralSecurityException {
        byte[] iv = new byte[this.ivSize];
        this.random.nextBytes(iv);
        Cipher cipher = Cipher.getInstance(this.transformation);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(this.gCMParameterSpecLen, iv);
        cipher.init(1, (Key)this.secretKey, parameterSpec);
        byte[] cipherText = cipher.doFinal(clearData);
        Arrays.fill(clearData, (byte)0);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + iv.length + cipherText.length);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        Arrays.fill(iv, (byte)0);
        byteBuffer.put(cipherText);
        return byteBuffer.array();
    }

    private byte[] internalUnCipher(byte[] rawData) throws GeneralSecurityException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(rawData);
        int ivLength = byteBuffer.getInt();
        byte[] iv = new byte[ivLength];
        byteBuffer.get(iv);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        Cipher cipher = Cipher.getInstance(this.transformation);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(this.gCMParameterSpecLen, iv);
        cipher.init(2, (Key)this.secretKey, parameterSpec);
        return cipher.doFinal(cipherText);
    }

    @Override
    public byte[] cipherFromData(byte[] clearData) {
        try {
            return this.internalCipher(clearData);
        }
        catch (GeneralSecurityException e) {
            log.error("Can't do cipher operation", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public byte[] unCipherToData(byte[] rawData) {
        try {
            return this.internalUnCipher(rawData);
        }
        catch (GeneralSecurityException e) {
            log.error("Can't do cipher operation", (Throwable)e);
            return new byte[0];
        }
    }

    @Override
    public byte[] cipherFromString(String text) {
        return this.cipherFromData(text.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String unCipherToString(byte[] rawData) {
        return new String(this.unCipherToData(rawData), StandardCharsets.UTF_8);
    }

    public static final String byteToString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (byte element : b) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append(0);
            }
            sb.append(Integer.toString(v, 16).toLowerCase());
        }
        return sb.toString();
    }

    @Override
    public String computeSHA3FromString(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance(SHA3_512);
            md.update(text.getBytes(StandardCharsets.UTF_8));
            return CipherServiceImpl.byteToString(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
    }
}

