/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import tv.hd3g.authkit.mod.entity.BaseEntity;

@Entity
@Table(name="audit")
public class Audit
extends BaseEntity {
    @NotEmpty
    @Column(length=60)
    private String appname;
    @NotEmpty
    @Column(length=38)
    private String eventref;
    @NotNull
    @Column(length=128)
    private String clientsourcehost;
    @NotNull
    private Integer clientsourceport;
    @NotEmpty
    private String eventname;
    @NotEmpty
    @Column(length=10)
    private String requestprotocol;
    @NotEmpty
    @Column(length=10)
    private String requestmethod;
    @NotNull
    @Column(length=128)
    private String requestserverhost;
    @NotNull
    private Integer requestserverport;
    @NotEmpty
    @Column(length=255)
    private String requestpath;
    @NotEmpty
    @Column(length=255)
    private String requestcontenttype;
    @NotNull
    private Long requestlength;
    @Column(length=1024)
    private String context;
    @Column(length=255)
    private String triggeredexception;
    @Column(length=38)
    private String useruuid;

    public Audit() {
    }

    private static String pSize(String entry, int maxSize) {
        if (entry == null) {
            return null;
        }
        if (entry.length() <= maxSize) {
            return entry;
        }
        return entry.substring(0, maxSize);
    }

    public Audit(String appname, String eventref, String clientsourcehost, Integer clientsourceport, String requestserverhost, Integer requestserverport, String eventname, String requestprotocol, String requestmethod, String requestpath, String requestcontenttype, long requestlength) {
        this.initCreate();
        this.appname = Audit.pSize(appname, 60);
        this.eventref = Audit.pSize(eventref, 38);
        this.clientsourcehost = clientsourcehost;
        this.clientsourceport = clientsourceport;
        this.requestserverhost = requestserverhost;
        this.requestserverport = requestserverport;
        this.eventname = Audit.pSize(eventname, 60);
        this.requestprotocol = Audit.pSize(requestprotocol, 10);
        this.requestmethod = Audit.pSize(requestmethod, 10);
        this.requestpath = Audit.pSize(requestpath, 255);
        this.requestcontenttype = Audit.pSize(requestcontenttype, 255);
        this.requestlength = requestlength;
    }

    public String getAppname() {
        return this.appname;
    }

    public String getEventref() {
        return this.eventref;
    }

    public String getClientsourcehost() {
        return this.clientsourcehost;
    }

    public Integer getClientsourceport() {
        return this.clientsourceport;
    }

    public String getRequestserverhost() {
        return this.requestserverhost;
    }

    public Integer getRequestserverport() {
        return this.requestserverport;
    }

    public String getEventname() {
        return this.eventname;
    }

    public String getRequestprotocol() {
        return this.requestprotocol;
    }

    public String getRequestmethod() {
        return this.requestmethod;
    }

    public String getRequestpath() {
        return this.requestpath;
    }

    public String getContext() {
        return this.context;
    }

    public Long getRequestlength() {
        return this.requestlength;
    }

    public void setContext(String context) {
        this.context = Audit.pSize(context, 1024);
    }

    public String getTriggeredexception() {
        return this.triggeredexception;
    }

    public void setTriggeredexception(String triggeredexception) {
        this.triggeredexception = Audit.pSize(triggeredexception, 255);
    }

    public String getUseruuid() {
        return this.useruuid;
    }

    public void setUseruuid(String useruuid) {
        this.useruuid = Audit.pSize(useruuid, 38);
    }
}

