/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.dto.validated;

import java.util.Optional;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.utility.LogSanitizer;

public class LoginFormDto {
    @NotBlank
    private String userlogin;
    @NotNull
    private Password userpassword;
    @NotBlank
    private String securetoken;
    private Boolean shorttime;

    public String getUserlogin() {
        return LogSanitizer.sanitize(this.userlogin);
    }

    public void setUserlogin(String userlogin) {
        this.userlogin = userlogin;
    }

    public Password getUserpassword() {
        return this.userpassword;
    }

    public void setUserpassword(Password userpassword) {
        this.userpassword = userpassword;
    }

    public String getSecuretoken() {
        return this.securetoken;
    }

    public void setSecuretoken(String securetoken) {
        this.securetoken = securetoken;
    }

    public Boolean getShorttime() {
        return this.shorttime;
    }

    public void setShorttime(Boolean shorttime) {
        this.shorttime = shorttime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("userLogin: ");
        sb.append(this.userlogin);
        sb.append(", userPassword: ");
        sb.append(Optional.ofNullable(this.userpassword).map(Password::toString).orElse("<null>"));
        if (this.isShortSessionTime()) {
            sb.append(", short time ");
        }
        sb.append(", secureToken: ");
        sb.append(this.securetoken);
        return sb.toString();
    }

    public boolean isShortSessionTime() {
        return Optional.ofNullable(this.shorttime).orElse(false);
    }
}

