/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.component;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tv.hd3g.authkit.utility.AnnotatedControllerClass;

@Component
public class AuthKitEndpointsListener
implements ApplicationListener<ApplicationEvent> {
    private final ConcurrentHashMap<Class<?>, AnnotatedControllerClass> annotationCache = new ConcurrentHashMap();

    public void onApplicationEvent(ApplicationEvent aEvent) {
        if (aEvent instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent event = (ContextRefreshedEvent)aEvent;
            ((RequestMappingHandlerMapping)event.getApplicationContext().getBean(RequestMappingHandlerMapping.class)).getHandlerMethods().values().stream().map(HandlerMethod::getBeanType).forEach(this::getAnnotatedClass);
        }
    }

    public Set<String> getAllRights() {
        return this.annotationCache.values().stream().flatMap(AnnotatedControllerClass::getAllRights).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public AnnotatedControllerClass getAnnotatedClass(Class<?> controllerClass) {
        return this.annotationCache.computeIfAbsent(controllerClass, AnnotatedControllerClass::new);
    }
}

