/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import tv.hd3g.authkit.mod.dto.LoggedUserTagsTokenDto;
import tv.hd3g.authkit.mod.dto.SetupTOTPTokenDto;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.service.SecuredTokenService;

@Service
public class SecuredTokenServiceImpl
implements SecuredTokenService {
    private static Logger log = LogManager.getLogger();
    public static final String TOKEN_TYPE = "JWT";
    public static final String TOKEN_AUDIENCE = "authkit";
    public static final String TOKEN_ISSUER_FORM = "form";
    public static final String TOKEN_ISSUER_LOGIN = "loggedUser";
    public static final String TOKEN_ISSUER_SECUREDREQUEST = "UsrSecRq";
    public static final String TOKEN_ISSUER_SETUPTOTP = "setupTOTP";
    private static final String CLAIM_FORMNAME = "formname";
    private final byte[] secret;

    public SecuredTokenServiceImpl(@Value(value="${authkit.jwt_secret}") String base64secret) {
        this.secret = Base64.getDecoder().decode(base64secret.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String simpleFormGenerateToken(String formName, Duration expirationDuration) {
        long now = System.currentTimeMillis();
        return Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)TOKEN_TYPE).setIssuer(TOKEN_ISSUER_FORM).setAudience(TOKEN_AUDIENCE).setExpiration(new Date(now + expirationDuration.toMillis())).claim(CLAIM_FORMNAME, (Object)formName).compact();
    }

    private Jws<Claims> extractToken(String token, String expectedIssuer) throws NotAcceptableSecuredTokenException {
        try {
            String issuer;
            Jws parsedToken = Jwts.parserBuilder().setSigningKey(this.secret).build().parseClaimsJws(token);
            log.debug("Check token: {}", new Supplier[]{() -> parsedToken});
            String type = ((JwsHeader)parsedToken.getHeader()).getType();
            if (!TOKEN_TYPE.equals(type)) {
                log.warn("Invalid token type: {}", (Object)type);
                throw new NotAcceptableSecuredTokenException.BadUseSecuredTokenInvalidType(type, TOKEN_TYPE);
            }
            Claims claims = (Claims)parsedToken.getBody();
            if (expectedIssuer != null && !expectedIssuer.equals(issuer = claims.getIssuer())) {
                log.warn("Invalid token issuer: {}", (Object)issuer);
                throw new NotAcceptableSecuredTokenException.BadUseSecuredTokenInvalidIssuer(issuer, expectedIssuer);
            }
            String audience = claims.getAudience();
            if (!TOKEN_AUDIENCE.equals(audience)) {
                log.warn("Invalid token audience: {}", (Object)audience);
                throw new NotAcceptableSecuredTokenException.BadUseSecuredTokenInvalidAudience(audience, TOKEN_AUDIENCE);
            }
            return parsedToken;
        }
        catch (ExpiredJwtException exception) {
            log.warn("Parse expired JWT: {}", (Object)exception.getMessage());
            throw new NotAcceptableSecuredTokenException.ExpiredSecuredToken();
        }
        catch (UnsupportedJwtException exception) {
            log.warn("Parse unsupported JWT: {}", (Object)exception.getMessage());
            throw new NotAcceptableSecuredTokenException.InvalidFormatSecuredToken();
        }
        catch (MalformedJwtException exception) {
            log.warn("Parse invalid JWT: {}", (Object)exception.getMessage());
            throw new NotAcceptableSecuredTokenException.InvalidFormatSecuredToken();
        }
        catch (SignatureException exception) {
            log.warn("Parse JWT with invalid signature: {}", (Object)exception.getMessage());
            throw new NotAcceptableSecuredTokenException.BrokenSecuredToken();
        }
        catch (IllegalArgumentException exception) {
            log.warn("Parse empty or null JWT: {}", (Object)exception.getMessage());
            throw new NotAcceptableSecuredTokenException.InvalidFormatSecuredToken();
        }
    }

    @Override
    public void simpleFormCheckToken(String expectedFormName, String token) throws NotAcceptableSecuredTokenException {
        Jws<Claims> parsedToken = this.extractToken(token, TOKEN_ISSUER_FORM);
        Claims claims = (Claims)parsedToken.getBody();
        String tokenformName = (String)claims.get(CLAIM_FORMNAME, String.class);
        if (!expectedFormName.equals(tokenformName)) {
            log.warn("Invalid token form: {}", (Object)tokenformName);
            throw new NotAcceptableSecuredTokenException.BadUseSecuredTokenInvalidForm(tokenformName, TOKEN_ISSUER_FORM);
        }
    }

    @Override
    public String loggedUserRightsGenerateToken(String userUUID, Duration expirationDuration, Set<String> tags, String onlyForHost) {
        long now = System.currentTimeMillis();
        return Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)TOKEN_TYPE).setIssuer(TOKEN_ISSUER_LOGIN).setAudience(TOKEN_AUDIENCE).setSubject(userUUID).setExpiration(new Date(now + expirationDuration.toMillis())).claim("tags", tags).claim("host", (Object)onlyForHost).compact();
    }

    @Override
    public LoggedUserTagsTokenDto loggedUserRightsExtractToken(String token, boolean fromCookie) throws NotAcceptableSecuredTokenException {
        Claims claims = (Claims)this.extractToken(token, TOKEN_ISSUER_LOGIN).getBody();
        ArrayList rawTags = (ArrayList)claims.get("tags", ArrayList.class);
        String host = claims.containsKey((Object)"host") ? (String)claims.get("host", String.class) : null;
        Set<String> stringTags = rawTags.stream().map(d2 -> (String)d2).collect(Collectors.toUnmodifiableSet());
        return new LoggedUserTagsTokenDto(claims.getSubject(), stringTags, claims.getExpiration(), fromCookie, host);
    }

    @Override
    public String securedRedirectRequestGenerateToken(String userUUID, Duration expirationDuration, String target) {
        long now = System.currentTimeMillis();
        return Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)TOKEN_TYPE).setIssuer("UsrSecRq/" + target).setAudience(TOKEN_AUDIENCE).setSubject(userUUID).setExpiration(new Date(now + expirationDuration.toMillis())).compact();
    }

    @Override
    public String securedRedirectRequestExtractToken(String token, String expectedTarget) throws NotAcceptableSecuredTokenException {
        return ((Claims)this.extractToken(token, "UsrSecRq/" + expectedTarget).getBody()).getSubject();
    }

    @Override
    public String userFormGenerateToken(String formName, String userUUID, Duration expirationDuration) {
        long now = System.currentTimeMillis();
        return Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)TOKEN_TYPE).setIssuer(TOKEN_ISSUER_FORM).setAudience(TOKEN_AUDIENCE).setSubject(userUUID).setExpiration(new Date(now + expirationDuration.toMillis())).claim(CLAIM_FORMNAME, (Object)formName).compact();
    }

    @Override
    public String userFormExtractTokenUUID(String formName, String securetoken) throws NotAcceptableSecuredTokenException {
        Claims claims = (Claims)this.extractToken(securetoken, TOKEN_ISSUER_FORM).getBody();
        String expectedFormName = (String)claims.get(CLAIM_FORMNAME, String.class);
        if (!formName.equals(expectedFormName)) {
            log.warn("Invalid token form: {}", (Object)formName);
            throw new NotAcceptableSecuredTokenException.BadUseSecuredTokenInvalidForm(formName, TOKEN_ISSUER_FORM);
        }
        return claims.getSubject();
    }

    @Override
    public String setupTOTPGenerateToken(String userUUID, Duration expirationDuration, String secret, List<String> backupCodes) {
        long now = System.currentTimeMillis();
        return Jwts.builder().signWith((Key)Keys.hmacShaKeyFor((byte[])this.secret), SignatureAlgorithm.HS512).setHeaderParam("typ", (Object)TOKEN_TYPE).setIssuer(TOKEN_ISSUER_SETUPTOTP).setAudience(TOKEN_AUDIENCE).setSubject(userUUID).setExpiration(new Date(now + expirationDuration.toMillis())).claim("secret", (Object)secret).claim("backupCodes", backupCodes).compact();
    }

    @Override
    public SetupTOTPTokenDto setupTOTPExtractToken(String token) throws NotAcceptableSecuredTokenException {
        Claims claims = (Claims)this.extractToken(token, TOKEN_ISSUER_SETUPTOTP).getBody();
        ArrayList rawBackupCodes = (ArrayList)claims.get("backupCodes", ArrayList.class);
        Set<String> backupCodes = rawBackupCodes.stream().map(d2 -> (String)d2).collect(Collectors.toUnmodifiableSet());
        return new SetupTOTPTokenDto(claims.getSubject(), (String)claims.get("secret", String.class), backupCodes);
    }
}

