/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.config;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import tv.hd3g.authkit.utility.CIDRUtils;

@Configuration
@ConfigurationProperties(prefix="authkit.ldap")
public class ExternalLDAP {
    private List<LDAPEntry> servers;

    public boolean isAvailable() {
        return this.servers != null && !this.servers.isEmpty();
    }

    @PostConstruct
    public void init() {
        if (this.isAvailable()) {
            this.servers.forEach(LDAPEntry::init);
        }
    }

    public Optional<LDAPEntry> getByDomainName(String domain) {
        if (!this.isAvailable()) {
            return Optional.empty();
        }
        return this.getServers().stream().filter(server -> server.getDomain().equalsIgnoreCase(domain)).findFirst();
    }

    public List<LDAPEntry> getServers() {
        return this.servers;
    }

    public void setServers(List<LDAPEntry> servers) {
        this.servers = servers;
    }

    public static class LDAPEntry {
        private LDAPType type;
        private String host;
        private int port;
        @NotEmpty
        private String domain;
        private String ldapTenantName;
        private String ldapCommonName;
        private String ldapMailName;
        private String organizationalUnitsAttributeName;
        private String ldapSearchLogonQuery;
        private List<CIDRUtils> allowedCreate;

        public void init() {
            if (this.type == null || LDAPType.OTHER.equals((Object)this.type)) {
                throw new IllegalArgumentException("Not set or invalid LDAP Server type configuration: " + this.type);
            }
            if (this.host == null || this.host.isEmpty()) {
                this.host = "127.0.0.1";
            } else {
                try {
                    InetAddress.getByName(this.host);
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException("Invalid address for host configuration: " + this.host, e);
                }
            }
            if (this.port == 0) {
                this.port = 389;
            } else if (this.port < 1 || this.port > 65535) {
                throw new IllegalArgumentException("Invalid LDAP port in configuration: " + this.port);
            }
            this.ldapTenantName = LDAPEntry.setOptional(this.ldapTenantName, "sAMAccountName");
            this.ldapCommonName = LDAPEntry.setOptional(this.ldapCommonName, "cn");
            this.ldapMailName = LDAPEntry.setOptional(this.ldapMailName, "mail");
            this.ldapSearchLogonQuery = LDAPEntry.setOptional(this.ldapSearchLogonQuery, "(& (sAMAccountName=<ldapTenantName>)(objectClass=user))");
            this.organizationalUnitsAttributeName = LDAPEntry.setOptional(this.organizationalUnitsAttributeName, "distinguishedName");
            if (this.allowedCreate == null) {
                this.allowedCreate = List.of();
            }
        }

        public final boolean isAllowed(InetAddress externalAddress) {
            if (this.allowedCreate.isEmpty()) {
                return true;
            }
            return this.allowedCreate.stream().anyMatch(allowed -> allowed.isInRange(externalAddress));
        }

        private static final String setOptional(String currentVar, String currentDefault) {
            if (currentVar == null || currentVar.trim().isEmpty()) {
                return currentDefault;
            }
            return currentVar;
        }

        public void setType(LDAPType type) {
            this.type = type;
        }

        public LDAPType getType() {
            return this.type;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getDomain() {
            return this.domain;
        }

        public void setDomain(String domain) {
            this.domain = domain;
        }

        public String getLdapTenantName() {
            return this.ldapTenantName;
        }

        public void setLdapTenantName(String ldapTenantName) {
            this.ldapTenantName = ldapTenantName;
        }

        public String getLdapCommonName() {
            return this.ldapCommonName;
        }

        public void setLdapCommonName(String ldapCommonName) {
            this.ldapCommonName = ldapCommonName;
        }

        public String getOrganizationalUnitsAttributeName() {
            return this.organizationalUnitsAttributeName;
        }

        public void setOrganizationalUnitsAttributeName(String organizationalUnitsAttributeName) {
            this.organizationalUnitsAttributeName = organizationalUnitsAttributeName;
        }

        public String getLdapSearchLogonQuery() {
            return this.ldapSearchLogonQuery;
        }

        public void setLdapSearchLogonQuery(String ldapSearchLogonQuery) {
            this.ldapSearchLogonQuery = ldapSearchLogonQuery;
        }

        public String getLdapMailName() {
            return this.ldapMailName;
        }

        public void setLdapMailName(String ldapMailName) {
            this.ldapMailName = ldapMailName;
        }

        public void setAllowedCreate(List<CIDRUtils> allowedCreate) {
            this.allowedCreate = allowedCreate;
        }

        public List<CIDRUtils> getAllowedCreate() {
            return this.allowedCreate;
        }
    }

    public static enum LDAPType {
        AD,
        OTHER;

    }
}

