/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.component;

import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.service.CmdLineService;

@Component
public class SecurityAdminAccountCmdLineCreator
implements ApplicationRunner {
    public static final String AUTHKIT_NEWADMIN_ENVKEY = "AUTHKIT_NEWADMIN";
    public static final String AUTHKIT_PASSWORD_ENVKEY = "AUTHKIT_PASSWORD";
    @Autowired
    private CmdLineService cmdLineService;

    @Transactional
    public void run(ApplicationArguments args) throws Exception {
        if (!args.getNonOptionArgs().contains("create-security-admin")) {
            return;
        }
        String newadmin = Optional.ofNullable(System.getenv(AUTHKIT_NEWADMIN_ENVKEY)).or(() -> Optional.ofNullable(System.getProperty(AUTHKIT_NEWADMIN_ENVKEY))).orElseThrow(() -> new IllegalArgumentException("You must set a \"AUTHKIT_NEWADMIN\" as environment var"));
        String password = Optional.ofNullable(System.getenv(AUTHKIT_PASSWORD_ENVKEY)).or(() -> Optional.ofNullable(System.getProperty(AUTHKIT_PASSWORD_ENVKEY))).orElseThrow(() -> new IllegalArgumentException("You must set a \"AUTHKIT_PASSWORD\" as environment var"));
        this.cmdLineService.addOrUpdateSecurityAdminUser(newadmin, new Password(password));
        if (!args.getNonOptionArgs().contains("dont-quit-after-done")) {
            System.exit(0);
        }
    }
}

