/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.utility;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tv.hd3g.authkit.utility.ControllerType;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.AuditAllAfter;
import tv.hd3g.commons.authkit.CheckBefore;
import tv.hd3g.commons.authkit.CheckOneBefore;
import tv.hd3g.commons.authkit.RenforceCheckBefore;

public class AnnotatedControllerClass {
    private final List<CheckBefore> allClassCheckBefore;
    private final Map<Method, List<CheckBefore>> allMethodsCheckBefore;
    private final Map<Method, List<AuditAfter>> auditAfterListByMethods;
    private final Map<Method, List<CheckBefore>> checkBeforeListByMethods;
    private final boolean allClassRenforceCheckBefore;
    private final Map<Method, Boolean> allMethodsRenforceCheckBefore;
    private final Map<Method, Boolean> allMethodsRequireValidAuth;
    private final ControllerType controllerType;

    public AnnotatedControllerClass(Class<?> referer) {
        Function<CheckOneBefore, Stream> extractCheckOnBefore = audits -> Arrays.stream(audits.value());
        Function<AuditAllAfter, Stream> extractAuditAllAfter = audits -> Arrays.stream(audits.value());
        List<Method> refererMethods = Arrays.stream(referer.getMethods()).toList();
        this.allClassCheckBefore = Stream.concat(Arrays.stream((CheckBefore[])referer.getAnnotationsByType(CheckBefore.class)), Arrays.stream((CheckOneBefore[])referer.getAnnotationsByType(CheckOneBefore.class)).flatMap(extractCheckOnBefore)).distinct().toList();
        List<AuditAfter> allClassAuditsAfter = Stream.concat(Arrays.stream((AuditAfter[])referer.getAnnotationsByType(AuditAfter.class)), Arrays.stream((AuditAllAfter[])referer.getAnnotationsByType(AuditAllAfter.class)).flatMap(extractAuditAllAfter)).distinct().toList();
        this.allClassRenforceCheckBefore = ((RenforceCheckBefore[])referer.getAnnotationsByType(RenforceCheckBefore.class)).length > 0;
        this.allMethodsCheckBefore = refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(Arrays.stream((CheckBefore[])method.getAnnotationsByType(CheckBefore.class)), Arrays.stream((CheckOneBefore[])method.getAnnotationsByType(CheckOneBefore.class)).flatMap(extractCheckOnBefore)).distinct().toList()));
        Map<Method, List> allMethodsAuditsAfter = refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(Arrays.stream((AuditAfter[])method.getAnnotationsByType(AuditAfter.class)), Arrays.stream((AuditAllAfter[])method.getAnnotationsByType(AuditAllAfter.class)).flatMap(extractAuditAllAfter)).distinct().toList()));
        this.allMethodsRenforceCheckBefore = refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> ((RenforceCheckBefore[])method.getAnnotationsByType(RenforceCheckBefore.class)).length > 0));
        this.allMethodsRequireValidAuth = this.allClassCheckBefore.isEmpty() ? refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> !this.allMethodsCheckBefore.get(method).isEmpty())) : refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> true));
        this.checkBeforeListByMethods = refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(this.allClassCheckBefore.stream(), this.allMethodsCheckBefore.getOrDefault(method, List.of()).stream()).toList()));
        this.auditAfterListByMethods = refererMethods.stream().collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(allClassAuditsAfter.stream(), allMethodsAuditsAfter.getOrDefault(method, List.of()).stream()).toList()));
        this.controllerType = ControllerType.getFromClass(referer);
    }

    public List<CheckBefore> getRequireAuthList(Method method) {
        return this.checkBeforeListByMethods.get(method);
    }

    public List<AuditAfter> getAudits(Method method) {
        return this.auditAfterListByMethods.get(method);
    }

    public boolean isRequireRenforceCheckBefore(Method method) {
        return this.allClassRenforceCheckBefore || this.allMethodsRenforceCheckBefore.getOrDefault(method, false) != false;
    }

    public boolean isRequireValidAuth(Method method) {
        return this.allMethodsRequireValidAuth.get(method);
    }

    public ControllerType getControllerType() {
        return this.controllerType;
    }

    public Stream<String> getAllRights() {
        return Stream.concat(this.allClassCheckBefore.stream(), this.allMethodsCheckBefore.values().stream().flatMap(Collection::stream)).flatMap(cb -> Arrays.stream(cb.value())).distinct();
    }
}

