/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.dto.ressource;

import java.util.Date;
import java.util.Objects;
import org.springframework.hateoas.RepresentationModel;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.entity.User;

public class UserDto
extends RepresentationModel<UserDto> {
    private final Date created;
    private final String uuid;
    private final String login;
    private final String realm;
    private final boolean enabled;
    private final boolean totpEnabled;
    private final String ldapDomain;
    private final boolean mustChangePassword;
    private final Date lastlogin;

    public UserDto(User user) {
        this.created = user.getCreated();
        this.uuid = user.getUuid();
        Credential c = user.getCredential();
        if (c == null) {
            this.login = null;
            this.realm = null;
            this.enabled = false;
            this.totpEnabled = false;
            this.ldapDomain = null;
            this.mustChangePassword = false;
            this.lastlogin = null;
            return;
        }
        this.login = c.getLogin();
        this.realm = c.getRealm();
        this.enabled = c.isEnabled();
        this.totpEnabled = c.getTotpkey() != null;
        this.ldapDomain = c.getLdapdomain();
        this.mustChangePassword = c.isMustchangepassword();
        this.lastlogin = c.getLastlogin();
    }

    public Date getCreated() {
        return this.created;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getLogin() {
        return this.login;
    }

    public String getRealm() {
        return this.realm;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTotpEnabled() {
        return this.totpEnabled;
    }

    public boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public Date getLastlogin() {
        return this.lastlogin;
    }

    public String getLdapDomain() {
        return this.ldapDomain;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.created, this.enabled, this.lastlogin, this.ldapDomain, this.login, this.mustChangePassword, this.realm, this.totpEnabled, this.uuid);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UserDto other = (UserDto)((Object)obj);
        return Objects.equals(this.created, other.created) && this.enabled == other.enabled && Objects.equals(this.lastlogin, other.lastlogin) && Objects.equals(this.ldapDomain, other.ldapDomain) && Objects.equals(this.login, other.login) && this.mustChangePassword == other.mustChangePassword && Objects.equals(this.realm, other.realm) && this.totpEnabled == other.totpEnabled && Objects.equals(this.uuid, other.uuid);
    }
}

