/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import tv.hd3g.authkit.mod.ControllerInterceptor;
import tv.hd3g.authkit.mod.SecurityRejectedRequestMappingExceptionResolver;
import tv.hd3g.authkit.mod.component.AuthKitEndpointsListener;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.CookieService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.authkit.utility.StringToPasswordConvertor;

@Configuration
public class AuthKitWebMvcConfigurer
implements WebMvcConfigurer {
    private final AuditReportService auditService;
    private final SecuredTokenService securedTokenService;
    private final AuthKitEndpointsListener authKitEndpointsListener;
    private final AuthenticationService authenticationService;
    private final CookieService cookieService;
    @Value(value="${authkit.auth-error-view:auth-error}")
    private String authErrorViewName;

    @Autowired
    public AuthKitWebMvcConfigurer(AuditReportService auditService, SecuredTokenService securedTokenService, AuthKitEndpointsListener authKitEndpointsListener, AuthenticationService authenticationService, CookieService cookieService) {
        this.auditService = auditService;
        this.securedTokenService = securedTokenService;
        this.authKitEndpointsListener = authKitEndpointsListener;
        this.authenticationService = authenticationService;
        this.cookieService = cookieService;
    }

    public void addFormatters(FormatterRegistry registry) {
        registry.addConverter((Converter)new StringToPasswordConvertor());
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new ControllerInterceptor(this.auditService, this.securedTokenService, this.authKitEndpointsListener, this.authenticationService, this.cookieService));
    }

    @Bean(name={"simpleMappingExceptionResolver"})
    public SimpleMappingExceptionResolver createSimpleMappingExceptionResolver() {
        return new SecurityRejectedRequestMappingExceptionResolver(this.auditService, this.cookieService, this.authErrorViewName);
    }
}

