/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.service;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import tv.hd3g.authkit.mod.dto.Password;
import tv.hd3g.authkit.mod.dto.ressource.GroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.ressource.UserDto;
import tv.hd3g.authkit.mod.dto.ressource.UserPrivacyDto;
import tv.hd3g.authkit.mod.dto.validated.AddGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.AddUserDto;
import tv.hd3g.authkit.mod.dto.validated.LoginFormDto;
import tv.hd3g.authkit.mod.dto.validated.RenameGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.TOTPLogonCodeFormDto;
import tv.hd3g.authkit.mod.entity.Credential;
import tv.hd3g.authkit.mod.exception.BlockedUserException;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.exception.ResetWithSamePasswordException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.service.AuditReportService;

public interface AuthenticationService {
    public String userLoginRequest(HttpServletRequest var1, LoginFormDto var2) throws UserCantLoginException;

    public String userLoginRequest(HttpServletRequest var1, TOTPLogonCodeFormDto var2) throws UserCantLoginException, NotAcceptableSecuredTokenException;

    public Optional<AuditReportService.RejectLoginCause> checkPassword(Password var1, Credential var2);

    public String addUser(AddUserDto var1);

    public void removeUser(String var1);

    public void disableUser(String var1);

    public void enableUser(String var1);

    public void resetUserLogonTrials(String var1);

    public boolean isUserEnabledAndNonBlocked(String var1);

    public void setUserMustChangePassword(String var1);

    public void changeUserPassword(String var1, Password var2) throws ResetWithSamePasswordException, BlockedUserException;

    public List<String> getRightsForUser(String var1, String var2);

    public List<String> getContextRightsForUser(String var1, String var2, String var3);

    public void addGroup(AddGroupOrRoleDto var1);

    public void renameGroup(RenameGroupOrRoleDto var1);

    public void setGroupDescription(AddGroupOrRoleDto var1);

    public void addUserInGroup(String var1, String var2);

    public void removeUserInGroup(String var1, String var2);

    public void removeGroup(String var1);

    public List<GroupOrRoleDto> listAllGroups();

    public List<GroupOrRoleDto> listGroupsForUser(String var1);

    public void addRole(AddGroupOrRoleDto var1);

    public void renameRole(RenameGroupOrRoleDto var1);

    public void setRoleDescription(AddGroupOrRoleDto var1);

    public void setRoleOnlyForClient(String var1, String var2);

    public void addGroupInRole(String var1, String var2);

    public void removeGroupInRole(String var1, String var2);

    public void removeRole(String var1);

    public List<GroupOrRoleDto> listAllRoles();

    public List<GroupOrRoleDto> listRolesForGroup(String var1);

    public void addRightInRole(String var1, String var2);

    public void removeRightInRole(String var1, String var2);

    public Set<String> getAllRights();

    public List<String> listRightsForRole(String var1);

    public void addContextInRight(String var1, String var2, String var3);

    public void removeContextInRight(String var1, String var2, String var3);

    public List<String> listContextsForRight(String var1, String var2);

    public List<UserDto> listLinkedUsersForGroup(String var1);

    public List<GroupOrRoleDto> listLinkedGroupsForRole(String var1);

    public List<UserPrivacyDto> getUserPrivacyList(Collection<String> var1);

    public void setUserPrivacy(String var1, UserPrivacyDto var2);
}

