/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.exception;

public abstract class UserCantLoginException
extends Exception {
    private final int httpReturnCode;

    public UserCantLoginException(int httpReturnCode) {
        this.httpReturnCode = httpReturnCode;
    }

    public int getHttpReturnCode() {
        return this.httpReturnCode;
    }

    public static final class ExternalAuthErrorCantLoginException
    extends UserCantLoginException {
        public ExternalAuthErrorCantLoginException() {
            super(500);
        }
    }

    public static final class UserMustChangePasswordException
    extends UserCantLoginException {
        private final String userUUID;

        public UserMustChangePasswordException(String userUUID) {
            super(200);
            this.userUUID = userUUID;
        }

        public String getUserUUID() {
            return this.userUUID;
        }
    }

    public static final class TOTPUserCantLoginException
    extends UserCantLoginException {
        private final String userUUID;

        public TOTPUserCantLoginException(String userUUID) {
            super(200);
            this.userUUID = userUUID;
        }

        public String getUserUUID() {
            return this.userUUID;
        }
    }

    public static final class BlockedUserCantLoginException
    extends UserCantLoginException {
        public BlockedUserCantLoginException() {
            super(401);
        }
    }

    public static final class BadTOTPCodeCantLoginException
    extends UserCantLoginException {
        public BadTOTPCodeCantLoginException() {
            super(401);
        }
    }

    public static final class BadPasswordUserCantLoginException
    extends UserCantLoginException {
        public BadPasswordUserCantLoginException() {
            super(401);
        }
    }

    public static final class NoPasswordUserCantLoginException
    extends UserCantLoginException {
        public NoPasswordUserCantLoginException() {
            super(400);
        }
    }

    public static final class DisabledUserCantLoginException
    extends UserCantLoginException {
        public DisabledUserCantLoginException() {
            super(401);
        }
    }

    public static final class UnknownUserCantLoginException
    extends UserCantLoginException {
        public UnknownUserCantLoginException() {
            super(401);
        }
    }
}

