/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.dto.ressource;

import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import javax.validation.constraints.Size;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import tv.hd3g.authkit.mod.dto.ExternalAuthUserDto;
import tv.hd3g.authkit.mod.entity.Userprivacy;

public class UserPrivacyDto
extends RepresentationModel<UserPrivacyDto> {
    @Nullable
    private Date created;
    @Nullable
    private String userUUID;
    @Nullable
    private String name;
    @Nullable
    private String address;
    @Nullable
    @Size(max=16)
    private @Size(max=16) String postalcode;
    @Nullable
    @Size(max=3)
    private @Size(max=3) String country;
    @Nullable
    @Size(max=3)
    private @Size(max=3) String lang;
    @Nullable
    private String email;
    @Nullable
    @Size(max=128)
    private @Size(max=128) String company;
    @Nullable
    private String phone;

    public UserPrivacyDto() {
    }

    public UserPrivacyDto(Userprivacy user, Function<byte[], String> unCipher) {
        this.created = user.getCreated();
        this.userUUID = user.getUserUUID();
        this.name = unCipher.apply(user.getName());
        this.address = unCipher.apply(user.getAddress());
        this.postalcode = user.getPostalcode();
        this.country = user.getCountry();
        this.lang = user.getLang();
        this.email = unCipher.apply(user.getEmail());
        this.company = user.getCompany();
        this.phone = unCipher.apply(user.getPhone());
    }

    public UserPrivacyDto(ExternalAuthUserDto importFromLDAP) {
        if (importFromLDAP.getUserLongName() != null) {
            this.name = importFromLDAP.getUserLongName();
        }
        if (importFromLDAP.getUserEmail() != null) {
            this.email = importFromLDAP.getUserEmail();
        }
    }

    public void mergue(Userprivacy user, Function<String, byte[]> cipher) {
        if (this.name != null) {
            user.setName(cipher.apply(this.name));
        }
        if (this.address != null) {
            user.setAddress(cipher.apply(this.address));
        }
        if (this.postalcode != null) {
            user.setPostalcode(this.postalcode);
        }
        if (this.country != null) {
            user.setCountry(this.country);
        }
        if (this.lang != null) {
            user.setLang(this.lang);
        }
        if (this.email != null) {
            user.setEmail(cipher.apply(this.email));
        }
        if (this.company != null) {
            user.setCompany(this.company);
        }
        if (this.phone != null) {
            user.setPhone(cipher.apply(this.phone));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.address, this.company, this.country, this.created, this.email, this.lang, this.name, this.phone, this.postalcode, this.userUUID);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UserPrivacyDto other = (UserPrivacyDto)((Object)obj);
        return Objects.equals(this.address, other.address) && Objects.equals(this.company, other.company) && Objects.equals(this.country, other.country) && Objects.equals(this.created, other.created) && Objects.equals(this.email, other.email) && Objects.equals(this.lang, other.lang) && Objects.equals(this.name, other.name) && Objects.equals(this.phone, other.phone) && Objects.equals(this.postalcode, other.postalcode) && Objects.equals(this.userUUID, other.userUUID);
    }

    public Date getCreated() {
        return this.created;
    }

    public String getUserUUID() {
        return this.userUUID;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPostalcode() {
        return this.postalcode;
    }

    public String getCountry() {
        return this.country;
    }

    public String getLang() {
        return this.lang;
    }

    public String getEmail() {
        return this.email;
    }

    public String getCompany() {
        return this.company;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setPostalcode(String postalcode) {
        this.postalcode = postalcode;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }
}

