/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.controller;

import java.util.List;
import java.util.UUID;
import javax.validation.constraints.NotEmpty;
import org.owasp.encoder.Encode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tv.hd3g.authkit.mod.LogSanitizer;
import tv.hd3g.authkit.mod.dto.ressource.CreatedUserDto;
import tv.hd3g.authkit.mod.dto.ressource.GroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.ressource.ItemListDto;
import tv.hd3g.authkit.mod.dto.ressource.UserDto;
import tv.hd3g.authkit.mod.dto.ressource.UserPrivacyDto;
import tv.hd3g.authkit.mod.dto.validated.AddGroupOrRoleDto;
import tv.hd3g.authkit.mod.dto.validated.AddUserDto;
import tv.hd3g.authkit.mod.dto.validated.ChangeIPDto;
import tv.hd3g.authkit.mod.dto.validated.ListStringDto;
import tv.hd3g.authkit.mod.dto.validated.RenameGroupOrRoleDto;
import tv.hd3g.authkit.mod.exception.AuthKitException;
import tv.hd3g.authkit.mod.repository.UserDao;
import tv.hd3g.authkit.mod.repository.UserRepository;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.CheckBefore;

@RestController
@RequestMapping(value={"/v1/authkit"}, produces={"application/json"})
@CheckBefore(value={"SecurityAdmin"})
public class RestControllerUser {
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private UserDao userDao;
    @Autowired
    private UserRepository userRepository;
    @Value(value="${authkit.dbMaxFetchSize:50}")
    private int dbMaxFetchSize;
    @Value(value="${authkit.realm:default}")
    private String realm;

    @Transactional(readOnly=false)
    @PostMapping(value={"users"})
    @AuditAfter(value="addUser", changeSecurity=true)
    public ResponseEntity<CreatedUserDto> addUser(@RequestBody @Validated AddUserDto addUser) {
        String uuid = this.authenticationService.addUser(addUser);
        CreatedUserDto result = new CreatedUserDto(Encode.forJavaScript((String)addUser.getUserLogin()), uuid, this.realm);
        return new ResponseEntity((Object)result, HttpStatus.CREATED);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/{uuid}"})
    @AuditAfter(value="getUser", changeSecurity=false)
    public ResponseEntity<UserDto> getUser(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        UserDto result = this.userDao.getUserByUUID(UUID.fromString(uuid)).orElseThrow(() -> new AuthKitException(404, "Can't found user " + uuid));
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users"})
    @AuditAfter(value="listUser", changeSecurity=false)
    public ResponseEntity<ItemListDto<UserDto>> listUsers(@RequestParam(defaultValue="0") int pos, @RequestParam(defaultValue="0") int size) {
        List<Object> list;
        int selectedPos;
        int limit;
        int total = (int)this.userRepository.count();
        if (total == 0) {
            limit = 0;
            selectedPos = 0;
            list = List.of();
        } else {
            limit = size < 1 ? this.dbMaxFetchSize : Math.min(total, Math.min(this.dbMaxFetchSize, size));
            selectedPos = Math.min(total - 1, Math.max(0, pos));
            list = this.userDao.getUserList(selectedPos, limit);
        }
        ItemListDto result = new ItemListDto(list);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Range", (Object)(selectedPos + "-" + limit + "/" + total));
        headers.add((Object)"Accept-Range", (Object)("user " + this.dbMaxFetchSize));
        if (list.size() == total) {
            return new ResponseEntity(result, (MultiValueMap)headers, HttpStatus.OK);
        }
        return new ResponseEntity(result, (MultiValueMap)headers, HttpStatus.PARTIAL_CONTENT);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/disable"})
    @AuditAfter(value="disableUser", changeSecurity=true)
    public ResponseEntity<Object> disableUser(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        this.authenticationService.disableUser(uuid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/enable"})
    @AuditAfter(value="enableUser", changeSecurity=true)
    public ResponseEntity<Object> enableUser(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        this.authenticationService.enableUser(uuid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/switchresetpassword"})
    @AuditAfter(value="switchUserMustResetPassword", changeSecurity=true)
    public ResponseEntity<Object> switchUserMustResetPassword(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        this.authenticationService.setUserMustChangePassword(uuid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/resetlogontrials"})
    @AuditAfter(value="resetUserLogonTrials", changeSecurity=true)
    public ResponseEntity<Object> resetUserLogonTrials(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        this.authenticationService.resetUserLogonTrials(uuid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @DeleteMapping(value={"users/{uuid}"})
    @AuditAfter(value="removeUser", changeSecurity=true)
    public ResponseEntity<Object> removeUser(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        this.authenticationService.removeUser(uuid);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addGroup", changeSecurity=true)
    @PostMapping(value={"groups"})
    public ResponseEntity<Object> addGroup(@RequestBody @Validated AddGroupOrRoleDto newGroup) {
        this.authenticationService.addGroup(newGroup);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="renameGroup", changeSecurity=true)
    @PostMapping(value={"groups/rename"})
    public ResponseEntity<Object> renameGroup(@RequestBody @Validated RenameGroupOrRoleDto renameGroup) {
        this.authenticationService.renameGroup(renameGroup);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setGroupDescription", changeSecurity=true)
    @PutMapping(value={"groups/description"})
    public ResponseEntity<Object> setGroupDescription(@RequestBody @Validated AddGroupOrRoleDto changeGroup) {
        this.authenticationService.setGroupDescription(changeGroup);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addUserInGroup", changeSecurity=true)
    @PostMapping(value={"users/{uuid}/ingroup/{name}"})
    public ResponseEntity<Object> addUserInGroup(@PathVariable(value="uuid") @NotEmpty String _userUUID, @PathVariable(value="name") @NotEmpty String _groupName) {
        String userUUID = LogSanitizer.sanitize(_userUUID);
        String groupName = LogSanitizer.sanitize(_groupName);
        this.authenticationService.addUserInGroup(userUUID, groupName);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeUserInGroup", changeSecurity=true)
    @DeleteMapping(value={"users/{uuid}/ingroup/{name}"})
    public ResponseEntity<Object> removeUserInGroup(@PathVariable(value="uuid") @NotEmpty String _userUUID, @PathVariable(value="name") @NotEmpty String _groupName) {
        String userUUID = LogSanitizer.sanitize(_userUUID);
        String groupName = LogSanitizer.sanitize(_groupName);
        this.authenticationService.removeUserInGroup(userUUID, groupName);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeGroup", changeSecurity=true)
    @DeleteMapping(value={"groups/{name}"})
    public ResponseEntity<Object> removeGroup(@PathVariable(value="name") @NotEmpty String _groupName) {
        String groupName = LogSanitizer.sanitize(_groupName);
        this.authenticationService.removeGroup(groupName);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listAllGroups", changeSecurity=false)
    @GetMapping(value={"groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listAllGroups() {
        ItemListDto<GroupOrRoleDto> result = new ItemListDto<GroupOrRoleDto>(this.authenticationService.listAllGroups());
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listGroupsForUser", changeSecurity=false)
    @GetMapping(value={"users/{uuid}/groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listGroupsForUser(@PathVariable(value="uuid") @NotEmpty String _userUUID) {
        String userUUID = LogSanitizer.sanitize(_userUUID);
        ItemListDto<GroupOrRoleDto> result = new ItemListDto<GroupOrRoleDto>(this.authenticationService.listGroupsForUser(userUUID));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addRole", changeSecurity=true)
    @PostMapping(value={"roles"})
    public ResponseEntity<Object> addRole(@RequestBody @Validated AddGroupOrRoleDto newRole) {
        this.authenticationService.addRole(newRole);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="renameRole", changeSecurity=true)
    @PostMapping(value={"roles/rename"})
    public ResponseEntity<Object> renameRole(@RequestBody @Validated RenameGroupOrRoleDto renameRole) {
        this.authenticationService.renameRole(renameRole);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setRoleDescription", changeSecurity=true)
    @PutMapping(value={"roles/description"})
    public ResponseEntity<Object> setRoleDescription(@RequestBody @Validated AddGroupOrRoleDto changeRole) {
        this.authenticationService.setRoleDescription(changeRole);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="setRoleOnlyForClients", changeSecurity=true)
    @PutMapping(value={"roles/{rolename}/setOnlyForClient"})
    public ResponseEntity<Object> setRoleOnlyForClient(@PathVariable(value="rolename") @NotEmpty String _roleName, @RequestBody @Validated ChangeIPDto setIp) {
        String roleName = LogSanitizer.sanitize(_roleName);
        this.authenticationService.setRoleOnlyForClient(roleName, setIp.getIp());
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addGroupInRole", changeSecurity=true)
    @PostMapping(value={"groups/{groupname}/inrole/{rolename}"})
    public ResponseEntity<Object> addGroupInRole(@PathVariable(value="groupname") @NotEmpty String _groupName, @PathVariable(value="rolename") @NotEmpty String _roleName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String groupName = LogSanitizer.sanitize(_groupName);
        this.authenticationService.addGroupInRole(groupName, roleName);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeGroupInRole", changeSecurity=true)
    @DeleteMapping(value={"groups/{groupname}/inrole/{rolename}"})
    public ResponseEntity<Object> removeGroupInRole(@PathVariable(value="groupname") @NotEmpty String _groupName, @PathVariable(value="rolename") @NotEmpty String _roleName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String groupName = LogSanitizer.sanitize(_groupName);
        this.authenticationService.removeGroupInRole(groupName, roleName);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeRole", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}"})
    public ResponseEntity<Object> removeRole(@PathVariable(value="rolename") @NotEmpty String _roleName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        this.authenticationService.removeRole(roleName);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listAllRoles", changeSecurity=false)
    @GetMapping(value={"roles"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listAllRoles() {
        ItemListDto<GroupOrRoleDto> result = new ItemListDto<GroupOrRoleDto>(this.authenticationService.listAllRoles());
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listRolesForGroup", changeSecurity=false)
    @GetMapping(value={"groups/{groupname}/roles"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listRolesForGroup(@PathVariable(value="groupname") @NotEmpty String _groupName) {
        String groupName = LogSanitizer.sanitize(_groupName);
        ItemListDto<GroupOrRoleDto> result = new ItemListDto<GroupOrRoleDto>(this.authenticationService.listRolesForGroup(groupName));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addRightInRole", changeSecurity=true)
    @PostMapping(value={"roles/{rolename}/rights/{rightname}"})
    public ResponseEntity<Object> addRightInRole(@PathVariable(value="rolename") @NotEmpty String _roleName, @PathVariable(value="rightname") @NotEmpty String _rightName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String rightName = LogSanitizer.sanitize(_rightName);
        this.authenticationService.addRightInRole(roleName, rightName);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeRightInRole", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}/rights/{rightname}"})
    public ResponseEntity<Object> removeRightInRole(@PathVariable(value="rolename") @NotEmpty String _roleName, @PathVariable(value="rightname") @NotEmpty String _rightName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String rightName = LogSanitizer.sanitize(_rightName);
        this.authenticationService.removeRightInRole(roleName, rightName);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="getAllRights", changeSecurity=false)
    @GetMapping(value={"rights"})
    public ResponseEntity<ItemListDto<String>> getAllRights() {
        ItemListDto<String> result = new ItemListDto<String>(this.authenticationService.getAllRights());
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listRightsForRole", changeSecurity=false)
    @GetMapping(value={"roles/{rolename}/rights"})
    public ResponseEntity<ItemListDto<String>> listRightsForRole(@PathVariable(value="rolename") @NotEmpty String _roleName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        ItemListDto<String> result = new ItemListDto<String>(this.authenticationService.listRightsForRole(roleName));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="addContextInRight", changeSecurity=true)
    @PostMapping(value={"roles/{rolename}/rights/{rightname}/contexts/{context}"})
    public ResponseEntity<Object> addContextInRight(@PathVariable(value="rolename") @NotEmpty String _roleName, @PathVariable(value="rightname") @NotEmpty String _rightName, @PathVariable(value="context") @NotEmpty String _context) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String rightName = LogSanitizer.sanitize(_rightName);
        String context = LogSanitizer.sanitize(_context);
        this.authenticationService.addContextInRight(roleName, rightName, context);
        return new ResponseEntity(HttpStatus.CREATED);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="removeContextInRight", changeSecurity=true)
    @DeleteMapping(value={"roles/{rolename}/rights/{rightname}/contexts/{context}"})
    public ResponseEntity<Object> removeContextInRight(@PathVariable(value="rolename") @NotEmpty String _roleName, @PathVariable(value="rightname") @NotEmpty String _rightName, @PathVariable(value="context") @NotEmpty String _context) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String rightName = LogSanitizer.sanitize(_rightName);
        String context = LogSanitizer.sanitize(_context);
        this.authenticationService.removeContextInRight(roleName, rightName, context);
        return new ResponseEntity(HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listContextsForRight", changeSecurity=false)
    @GetMapping(value={"roles/{rolename}/rights/{rightname}/contexts"})
    public ResponseEntity<ItemListDto<String>> listContextsForRight(@PathVariable(value="rolename") @NotEmpty String _roleName, @PathVariable(value="rightname") @NotEmpty String _rightName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        String rightName = LogSanitizer.sanitize(_rightName);
        ItemListDto<String> result = new ItemListDto<String>(this.authenticationService.listContextsForRight(roleName, rightName));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listLinkedUsersForGroup", changeSecurity=false)
    @GetMapping(value={"groups/{name}/users"})
    public ResponseEntity<ItemListDto<UserDto>> listLinkedUsersForGroup(@PathVariable(value="name") @NotEmpty String _groupName) {
        String groupName = LogSanitizer.sanitize(_groupName);
        ItemListDto<UserDto> result = new ItemListDto<UserDto>(this.authenticationService.listLinkedUsersForGroup(groupName));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @AuditAfter(value="listLinkedGroupsForRole", changeSecurity=false)
    @GetMapping(value={"roles/{name}/groups"})
    public ResponseEntity<ItemListDto<GroupOrRoleDto>> listLinkedGroupsForRole(@PathVariable(value="name") @NotEmpty String _roleName) {
        String roleName = LogSanitizer.sanitize(_roleName);
        ItemListDto<GroupOrRoleDto> result = new ItemListDto<GroupOrRoleDto>(this.authenticationService.listLinkedGroupsForRole(roleName));
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/{uuid}/privacy"})
    @AuditAfter(value="getUserPrivacy", changeSecurity=false)
    public ResponseEntity<UserPrivacyDto> getUserPrivacy(@PathVariable(value="uuid") @NotEmpty String _uuid) {
        String uuid = LogSanitizer.sanitize(_uuid);
        List<UserPrivacyDto> list = this.authenticationService.getUserPrivacyList(List.of(uuid));
        UserPrivacyDto result = list.isEmpty() ? new UserPrivacyDto() : list.get(0);
        return new ResponseEntity((Object)result, HttpStatus.OK);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"users/privacy"})
    @AuditAfter(value="getUsersPrivacy", changeSecurity=false)
    public ResponseEntity<ItemListDto<UserPrivacyDto>> getUsersPrivacy(@RequestBody @Validated ListStringDto userUUIDList) {
        List<UserPrivacyDto> list = this.authenticationService.getUserPrivacyList(userUUIDList.getList());
        ItemListDto<UserPrivacyDto> result = new ItemListDto<UserPrivacyDto>(list);
        return new ResponseEntity(result, HttpStatus.OK);
    }

    @Transactional(readOnly=false)
    @PutMapping(value={"users/{uuid}/privacy"})
    @AuditAfter(value="setUserPrivacy", changeSecurity=true)
    public ResponseEntity<Object> setUserPrivacy(@RequestBody @Validated UserPrivacyDto userPrivacyDto, @PathVariable(value="uuid") @NotEmpty String _userUUID) {
        String userUUID = LogSanitizer.sanitize(_userUUID);
        this.authenticationService.setUserPrivacy(userUUID, userPrivacyDto);
        return new ResponseEntity(HttpStatus.OK);
    }
}

