/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.controller;

import java.time.Duration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import tv.hd3g.authkit.mod.dto.validated.LoginFormDto;
import tv.hd3g.authkit.mod.dto.validated.ResetPasswordFormDto;
import tv.hd3g.authkit.mod.dto.validated.TOTPLogonCodeFormDto;
import tv.hd3g.authkit.mod.exception.BlockedUserException;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.exception.ResetWithSamePasswordException;
import tv.hd3g.authkit.mod.exception.UserCantLoginException;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.commons.authkit.AuditAfter;

@Controller
public class ControllerLogin {
    public static final String TOKEN_FORMNAME_LOGIN = "login";
    public static final String TOKEN_FORMNAME_RESET_PSD = "reset-password";
    public static final String TOKEN_FORMNAME_ENTER_TOTP = "totp-code";
    public static final String TOKEN_REDIRECT_RESET_PSD = "rpasswd";
    private static final String TMPL_NAME_LOGIN = "login";
    private static final String TMPL_NAME_RESET_PSD = "reset-password";
    private static final String TMPL_NAME_TOTP = "totp-challenge";
    private static final String TMPL_ATTR_ERROR = "error";
    private static final String TMPL_ATTR_FORMTOKEN = "formtoken";
    @Autowired
    private SecuredTokenService tokenService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AuthenticationService authenticationService;
    @Value(value="${authkit.maxLoginTime:5m}")
    private Duration expirationDuration;

    private String makeToken() {
        return this.tokenService.simpleFormGenerateToken("login", this.expirationDuration);
    }

    @GetMapping(value={"/login"})
    public String login(Model model) {
        model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
        return "login";
    }

    @PostMapping(value={"/login"})
    @AuditAfter(useSecurity=true, value="Auth login page")
    public String doLogin(Model model, @ModelAttribute @Valid LoginFormDto form, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) {
        if (bindingResult.hasErrors()) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.login.form-error", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        try {
            this.tokenService.simpleFormCheckToken("login", form.getSecuretoken());
            String userSessionToken = this.authenticationService.userLoginRequest(request, form);
            model.addAttribute("jwtsession", (Object)userSessionToken);
            return "bounce-session";
        }
        catch (NotAcceptableSecuredTokenException e) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage(e.getClass().getSimpleName(), null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        catch (UserCantLoginException.TOTPUserCantLoginException e) {
            String userUUID = e.getUserUUID();
            String token = this.tokenService.userFormGenerateToken(TOKEN_FORMNAME_ENTER_TOTP, userUUID, this.expirationDuration);
            model.addAttribute("shorttime", (Object)form.getShorttime());
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)token);
            return TMPL_NAME_TOTP;
        }
        catch (UserCantLoginException.UserMustChangePasswordException e) {
            String userUUID = e.getUserUUID();
            String token = this.tokenService.userFormGenerateToken("reset-password", userUUID, this.expirationDuration);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)token);
            return "reset-password";
        }
        catch (UserCantLoginException e) {
            response.setStatus(e.getHttpReturnCode());
            String errorMessage = this.messageSource.getMessage(e.getClass().getSimpleName(), null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
    }

    @GetMapping(value={"/logout"})
    public String logout() {
        return "bounce-logout";
    }

    @GetMapping(value={"/reset-password/{token}"})
    public String resetPassword(@PathVariable(value="token") @NotEmpty String token, Model model, HttpServletRequest request, HttpServletResponse response) {
        String userUUID;
        try {
            userUUID = this.tokenService.securedRedirectRequestExtractToken(token, TOKEN_REDIRECT_RESET_PSD);
        }
        catch (NotAcceptableSecuredTokenException e) {
            response.setStatus(400);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        String userFormToken = this.tokenService.userFormGenerateToken("reset-password", userUUID, this.expirationDuration);
        model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)userFormToken);
        return "reset-password";
    }

    @PostMapping(value={"/reset-password"})
    @AuditAfter(useSecurity=true, value="Reset password", changeSecurity=true)
    public String doResetPassword(Model model, @ModelAttribute @Valid ResetPasswordFormDto form, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) {
        if (bindingResult.hasErrors()) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.reset-password.form-error", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)form.getSecuretoken());
            return "reset-password";
        }
        if (!form.checkSamePasswords()) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.reset-password.form-error.notsamepass", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)form.getSecuretoken());
            return "reset-password";
        }
        try {
            String userUUID = this.tokenService.userFormExtractTokenUUID("reset-password", form.getSecuretoken());
            this.authenticationService.changeUserPassword(userUUID, form.getNewuserpassword());
        }
        catch (ResetWithSamePasswordException e) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.reset-password.invalidpassword", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)form.getSecuretoken());
            return "reset-password";
        }
        catch (BlockedUserException e) {
            response.setStatus(401);
            String errorMessage = this.messageSource.getMessage("authkit.reset-password.blockeduser", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        catch (NotAcceptableSecuredTokenException e) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.reset-password.form-error", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        String doneMessage = this.messageSource.getMessage("authkit.reset-password.done", null, LocaleContextHolder.getLocale());
        model.addAttribute("actionDone", (Object)doneMessage);
        model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
        return "login";
    }

    @PostMapping(value={"/login-2auth"})
    @AuditAfter(useSecurity=true, value="TOTP Logon", changeSecurity=false)
    public String doTOTPLogin(Model model, @ModelAttribute @Valid TOTPLogonCodeFormDto form, BindingResult bindingResult, HttpServletRequest request, HttpServletResponse response) {
        if (bindingResult.hasErrors()) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage("authkit.login.form-error", null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        try {
            String userSessionToken = this.authenticationService.userLoginRequest(request, form);
            model.addAttribute("jwtsession", (Object)userSessionToken);
        }
        catch (NotAcceptableSecuredTokenException e) {
            response.setStatus(400);
            String errorMessage = this.messageSource.getMessage(e.getClass().getSimpleName(), null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        catch (UserCantLoginException e) {
            response.setStatus(e.getHttpReturnCode());
            String errorMessage = this.messageSource.getMessage(e.getClass().getSimpleName(), null, LocaleContextHolder.getLocale());
            model.addAttribute(TMPL_ATTR_ERROR, (Object)errorMessage);
            model.addAttribute(TMPL_ATTR_FORMTOKEN, (Object)this.makeToken());
            return "login";
        }
        return "bounce-session";
    }
}

