/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod.component;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.AuditAllAfter;
import tv.hd3g.commons.authkit.CheckBefore;
import tv.hd3g.commons.authkit.CheckOneBefore;
import tv.hd3g.commons.authkit.RenforceCheckBefore;

@Component
public class AuthKitEndpointsListener
implements ApplicationListener<ApplicationEvent> {
    private final ConcurrentHashMap<Class<?>, AnnotatedClass> annotationCache = new ConcurrentHashMap();

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ((RequestMappingHandlerMapping)((ContextRefreshedEvent)event).getApplicationContext().getBean(RequestMappingHandlerMapping.class)).getHandlerMethods().values().stream().map(HandlerMethod::getBeanType).forEach(this::getAnnotatedClass);
        }
    }

    public Set<String> getAllRights() {
        return this.annotationCache.values().stream().flatMap(ac -> {
            Stream cl = ac.allClassCheckBefore.stream();
            Stream mc = ac.allMethodsCheckBefore.values().stream().flatMap(Collection::stream);
            return Stream.concat(cl, mc);
        }).flatMap(cb -> Arrays.stream(cb.value())).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public AnnotatedClass getAnnotatedClass(Class<?> controllerClass) {
        return this.annotationCache.computeIfAbsent(controllerClass, x$0 -> new AnnotatedClass((Class<?>)x$0));
    }

    public class AnnotatedClass {
        private final List<CheckBefore> allClassCheckBefore;
        private final Map<Method, List<CheckBefore>> allMethodsCheckBefore;
        private final List<AuditAfter> allClassAuditsAfter;
        private final Map<Method, List<AuditAfter>> allMethodsAuditsAfter;
        private final boolean allClassRenforceCheckBefore;
        private final Map<Method, Boolean> allMethodsRenforceCheckBefore;

        private AnnotatedClass(Class<?> referer) {
            Function<CheckOneBefore, Stream> extractCheckOnBefore = audits -> Arrays.stream(audits.value());
            Function<AuditAllAfter, Stream> extractAuditAllAfter = audits -> Arrays.stream(audits.value());
            this.allClassCheckBefore = Stream.concat(Arrays.stream((CheckBefore[])referer.getAnnotationsByType(CheckBefore.class)), Arrays.stream((CheckOneBefore[])referer.getAnnotationsByType(CheckOneBefore.class)).flatMap(extractCheckOnBefore)).distinct().collect(Collectors.toUnmodifiableList());
            this.allClassAuditsAfter = Stream.concat(Arrays.stream((AuditAfter[])referer.getAnnotationsByType(AuditAfter.class)), Arrays.stream((AuditAllAfter[])referer.getAnnotationsByType(AuditAllAfter.class)).flatMap(extractAuditAllAfter)).distinct().collect(Collectors.toUnmodifiableList());
            this.allClassRenforceCheckBefore = ((RenforceCheckBefore[])referer.getAnnotationsByType(RenforceCheckBefore.class)).length > 0;
            this.allMethodsCheckBefore = Arrays.stream(referer.getMethods()).collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(Arrays.stream((CheckBefore[])method.getAnnotationsByType(CheckBefore.class)), Arrays.stream((CheckOneBefore[])method.getAnnotationsByType(CheckOneBefore.class)).flatMap(extractCheckOnBefore)).distinct().collect(Collectors.toUnmodifiableList())));
            this.allMethodsAuditsAfter = Arrays.stream(referer.getMethods()).collect(Collectors.toUnmodifiableMap(method -> method, method -> Stream.concat(Arrays.stream((AuditAfter[])method.getAnnotationsByType(AuditAfter.class)), Arrays.stream((AuditAllAfter[])method.getAnnotationsByType(AuditAllAfter.class)).flatMap(extractAuditAllAfter)).distinct().collect(Collectors.toUnmodifiableList())));
            this.allMethodsRenforceCheckBefore = Arrays.stream(referer.getMethods()).collect(Collectors.toUnmodifiableMap(method -> method, method -> ((RenforceCheckBefore[])method.getAnnotationsByType(RenforceCheckBefore.class)).length > 0));
        }

        public List<CheckBefore> requireAuthList(Method method) {
            return Stream.concat(this.allClassCheckBefore.stream(), this.allMethodsCheckBefore.getOrDefault(method, List.of()).stream()).collect(Collectors.toUnmodifiableList());
        }

        public List<AuditAfter> getAudits(Method method) {
            return Stream.concat(this.allClassAuditsAfter.stream(), this.allMethodsAuditsAfter.getOrDefault(method, List.of()).stream()).collect(Collectors.toUnmodifiableList());
        }

        public boolean isRequireRenforceCheckBefore(Method method) {
            return this.allClassRenforceCheckBefore || this.allMethodsRenforceCheckBefore.getOrDefault(method, false) != false;
        }
    }
}

