/*
 * Decompiled with CFR 0.152.
 */
package tv.hd3g.authkit.mod;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;
import tv.hd3g.authkit.mod.LogSanitizer;
import tv.hd3g.authkit.mod.component.AuthKitEndpointsListener;
import tv.hd3g.authkit.mod.dto.LoggedUserTagsTokenDto;
import tv.hd3g.authkit.mod.exception.NotAcceptableSecuredTokenException;
import tv.hd3g.authkit.mod.service.AuditReportService;
import tv.hd3g.authkit.mod.service.AuditReportServiceImpl;
import tv.hd3g.authkit.mod.service.AuthenticationService;
import tv.hd3g.authkit.mod.service.SecuredTokenService;
import tv.hd3g.commons.authkit.AuditAfter;
import tv.hd3g.commons.authkit.CheckBefore;

public class ControllerInterceptor
implements HandlerInterceptor {
    private static Logger log = LogManager.getLogger();
    public static final String USER_UUID_ATTRIBUTE_NAME = ControllerInterceptor.class.getPackageName() + ".userUUID";
    private final AuditReportService auditService;
    private final SecuredTokenService securedTokenService;
    private final AuthKitEndpointsListener authKitEndpointsListener;
    private final AuthenticationService authenticationService;

    public ControllerInterceptor(AuditReportService auditService, SecuredTokenService securedTokenService, AuthKitEndpointsListener authKitEndpointsListener, AuthenticationService authenticationService) {
        this.auditService = auditService;
        this.securedTokenService = securedTokenService;
        this.authKitEndpointsListener = authKitEndpointsListener;
        this.authenticationService = authenticationService;
    }

    private boolean isRequestIsHandle(HttpServletRequest request, Object handler) {
        if (handler instanceof ResourceHttpRequestHandler) {
            ResourceHttpRequestHandler httpHandler = (ResourceHttpRequestHandler)handler;
            Optional.ofNullable(httpHandler.getUrlPathHelper()).map(uph -> uph.getLookupPathForRequest(request)).ifPresent(h -> log.trace("HandlerH: {}", h));
            return false;
        }
        if (!(handler instanceof HandlerMethod)) {
            log.info("Unknown handler: {}", handler.getClass());
            return false;
        }
        return true;
    }

    private Optional<LoggedUserTagsTokenDto> extractAndCheckAuthToken(HttpServletRequest request) throws Unauthorized {
        LoggedUserTagsTokenDto loggedDto;
        Optional<String> oBearer = Optional.ofNullable(request.getHeader("Authorization")).filter(content -> content.toLowerCase().startsWith("bearer")).map(content -> content.substring("bearer".length()).trim());
        if (oBearer.isEmpty()) {
            return Optional.empty();
        }
        try {
            loggedDto = this.securedTokenService.loggedUserRightsExtractToken(oBearer.get());
        }
        catch (NotAcceptableSecuredTokenException e) {
            throw new Unauthorized("Invalid JWT in auth request from {}", AuditReportServiceImpl.getOriginalRemoteAddr(request));
        }
        Objects.requireNonNull(loggedDto);
        if (loggedDto.getOnlyForHost() != null) {
            InetAddress addr2;
            InetAddress addr1;
            try {
                addr1 = InetAddress.getByName(loggedDto.getOnlyForHost());
                addr2 = InetAddress.getByName(AuditReportServiceImpl.getOriginalRemoteAddr(request));
            }
            catch (UnknownHostException e) {
                addr1 = null;
                addr2 = null;
            }
            if (addr1 == null || !addr1.equals(addr2)) {
                throw new Unauthorized("Reject request for {} from {} because the actual token contain a IP restriction on {} only", loggedDto.getUserUUID(), AuditReportServiceImpl.getOriginalRemoteAddr(request), loggedDto.getOnlyForHost());
            }
        }
        return Optional.of(loggedDto);
    }

    private void compareUserRightsAndRequestMandatories(HttpServletRequest request, LoggedUserTagsTokenDto loggedUserTagsTokenDto, Method classMethod, AuthKitEndpointsListener.AnnotatedClass annotatedClass) throws BaseInternalException {
        List<CheckBefore> requireAuthList = annotatedClass.requireAuthList(classMethod);
        if (requireAuthList.isEmpty()) {
            return;
        }
        String userUUID = loggedUserTagsTokenDto.getUserUUID();
        if (userUUID == null) {
            throw new Unauthorized("Unauthorized user from {}", AuditReportServiceImpl.getOriginalRemoteAddr(request));
        }
        if (requireAuthList.stream().noneMatch(annotation -> Arrays.stream(annotation.value()).allMatch(loggedUserTagsTokenDto.getTags()::contains))) {
            throw new Forbidden("Forbidden user {} from {} to go to {}", userUUID, AuditReportServiceImpl.getOriginalRemoteAddr(request), request.getRequestURI());
        }
    }

    private void checkRenforcedRightsChecks(HttpServletRequest request, AuthKitEndpointsListener.AnnotatedClass annotatedClass, Method classMethod, LoggedUserTagsTokenDto tokenPayload) throws BaseInternalException {
        if (!annotatedClass.isRequireRenforceCheckBefore(classMethod)) {
            return;
        }
        String userUUID = tokenPayload.getUserUUID();
        if (!this.authenticationService.isUserEnabledAndNonBlocked(userUUID)) {
            throw new Unauthorized("User {} is now disabled/blocked before last login", userUUID);
        }
        String clientAddr = AuditReportServiceImpl.getOriginalRemoteAddr(request);
        Set actualTags = this.authenticationService.getRightsForUser(userUUID, clientAddr).stream().distinct().collect(Collectors.toUnmodifiableSet());
        for (String tag : tokenPayload.getTags()) {
            if (actualTags.contains(tag)) continue;
            throw new Forbidden("User {} has lost some rights (like {}) before last login from {}", userUUID, tag, AuditReportServiceImpl.getOriginalRemoteAddr(request));
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        if (!this.isRequestIsHandle(request, handler)) {
            return true;
        }
        try {
            LoggedUserTagsTokenDto tokenPayload = this.extractAndCheckAuthToken(request).orElse(new LoggedUserTagsTokenDto(null, Set.of(), null));
            String userUUID = tokenPayload.getUserUUID();
            request.setAttribute(USER_UUID_ATTRIBUTE_NAME, (Object)userUUID);
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Class controllerClass = handlerMethod.getBeanType();
            AuthKitEndpointsListener.AnnotatedClass annotatedClass = this.authKitEndpointsListener.getAnnotatedClass(controllerClass);
            Method classMethod = handlerMethod.getMethod();
            this.checkRenforcedRightsChecks(request, annotatedClass, classMethod, tokenPayload);
            this.compareUserRightsAndRequestMandatories(request, tokenPayload, classMethod, annotatedClass);
            if (userUUID == null) {
                log.info("Request {} {}:{}()", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName());
            } else {
                log.info("Request {} {}:{}() {}", (Object)controllerClass.getSimpleName(), (Object)request.getMethod(), (Object)handlerMethod.getMethod().getName(), (Object)userUUID);
            }
            return true;
        }
        catch (BaseInternalException e) {
            e.pushAudit(request);
            response.reset();
            response.sendError(e.statusCode);
            log.error(e.logMessage, e.logContent);
            return false;
        }
    }

    public static final Optional<String> getRequestUserUUID(HttpServletRequest request) {
        return Optional.ofNullable(request.getAttribute(USER_UUID_ATTRIBUTE_NAME)).map(o -> LogSanitizer.sanitize((String)o));
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        List<String> namesSimpleAudit;
        List<String> namesUseSecurity;
        Method classMethod;
        if (!(handler instanceof HandlerMethod)) {
            return;
        }
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Class controllerClass = handlerMethod.getBeanType();
        AuthKitEndpointsListener.AnnotatedClass annotatedClass = this.authKitEndpointsListener.getAnnotatedClass(controllerClass);
        List<AuditAfter> auditList = annotatedClass.getAudits(classMethod = handlerMethod.getMethod());
        if (auditList.isEmpty()) {
            return;
        }
        Optional.ofNullable(exception).ifPresent(e -> {
            List<String> names = auditList.stream().filter(AuditAfter::cantDoErrors).map(AuditAfter::value).collect(Collectors.toUnmodifiableList());
            if (!names.isEmpty()) {
                this.auditService.onImportantError(request, names, (Exception)e);
            }
        });
        List<String> namesChangeSecurity = auditList.stream().filter(AuditAfter::changeSecurity).map(AuditAfter::value).collect(Collectors.toUnmodifiableList());
        if (!namesChangeSecurity.isEmpty()) {
            this.auditService.onChangeSecurity(request, namesChangeSecurity);
        }
        if (!(namesUseSecurity = auditList.stream().filter(AuditAfter::useSecurity).map(AuditAfter::value).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            this.auditService.onUseSecurity(request, namesUseSecurity);
        }
        if (!(namesSimpleAudit = auditList.stream().filter(audit -> !audit.cantDoErrors() && !audit.changeSecurity() && !audit.useSecurity()).map(AuditAfter::value).collect(Collectors.toUnmodifiableList())).isEmpty()) {
            this.auditService.onSimpleEvent(request, namesSimpleAudit);
        }
    }

    private class Forbidden
    extends BaseInternalException {
        protected Forbidden(String logMessage, Object ... logContent) {
            super(403, logMessage, logContent);
        }

        @Override
        protected void pushAudit(HttpServletRequest request) {
            ControllerInterceptor.this.auditService.interceptForbiddenRequest(request);
        }
    }

    private class Unauthorized
    extends BaseInternalException {
        protected Unauthorized(String logMessage, Object ... logContent) {
            super(401, logMessage, logContent);
        }

        @Override
        protected void pushAudit(HttpServletRequest request) {
            ControllerInterceptor.this.auditService.interceptUnauthorizedRequest(request);
        }
    }

    private abstract class BaseInternalException
    extends Exception {
        private final int statusCode;
        private final String logMessage;
        private final Object[] logContent;

        protected BaseInternalException(int statusCode, String logMessage, Object[] logContent) {
            this.statusCode = statusCode;
            this.logMessage = logMessage;
            this.logContent = logContent;
        }

        protected abstract void pushAudit(HttpServletRequest var1);

        private void writeObject(ObjectOutputStream out) throws IOException {
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        }
    }
}

