/*
 * Decompiled with CFR 0.152.
 */
package xitrum.i18n;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scaposer.I18n;
import scaposer.I18n$;
import scaposer.ParseFailure;
import scaposer.Parser$;
import sclasner.Discoverer$;
import xitrum.package$;
import xitrum.util.FileMonitor$;
import xitrum.util.Loader$;

public final class PoLoader$ {
    public static PoLoader$ MODULE$;
    private final String DEV_RESOURCES_DIR;
    private final Map<String, I18n> cache;

    static {
        new PoLoader$();
    }

    private String DEV_RESOURCES_DIR() {
        return this.DEV_RESOURCES_DIR;
    }

    private Map<String, I18n> cache() {
        return this.cache;
    }

    public I18n get(String language) {
        I18n i18n;
        if (this.cache().isDefinedAt((Object)language)) {
            return (I18n)this.cache().apply((Object)language);
        }
        PoLoader$ poLoader$ = this;
        synchronized (poLoader$) {
            Enumeration<URL> urlEnum = Thread.currentThread().getContextClassLoader().getResources(new StringBuilder(8).append("i18n/").append(language).append(".po").toString());
            ArrayBuffer buffer = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            while (urlEnum.hasMoreElements()) {
                BoxedUnit boxedUnit;
                URL url = urlEnum.nextElement();
                InputStream is = url.openStream();
                String string = Loader$.MODULE$.stringFromInputStream(is);
                Either either = Parser$.MODULE$.parse((CharSequence)string);
                if (either instanceof Left) {
                    BoxedUnit boxedUnit2;
                    Left left = (Left)either;
                    ParseFailure parseFailure = (ParseFailure)left.value();
                    if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
                        package$.MODULE$.Log().underlying().warn(new StringBuilder(17).append("Could not load ").append(url).append(": ").append(parseFailure).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    Seq translations = (Seq)right.value();
                    I18n i18n2 = I18n$.MODULE$.apply(translations);
                    buffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new I18n[]{i18n2}));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)either);
            }
            File file = new File(new StringBuilder(9).append(this.DEV_RESOURCES_DIR()).append("/i18n/").append(language).append(".po").toString());
            if (file.exists()) {
                String string = Loader$.MODULE$.stringFromFile(file);
                Either either = Parser$.MODULE$.parse((CharSequence)string);
                if (either instanceof Left) {
                    BoxedUnit boxedUnit;
                    Left left = (Left)either;
                    ParseFailure parseFailure = (ParseFailure)left.value();
                    if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
                        package$.MODULE$.Log().underlying().warn(new StringBuilder(17).append("Could not load ").append(file).append(": ").append(parseFailure).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit3 = boxedUnit;
                } else if (either instanceof Right) {
                    Right right = (Right)either;
                    Seq translations = (Seq)right.value();
                    I18n i18n3 = I18n$.MODULE$.apply(translations);
                    buffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new I18n[]{i18n3}));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)either);
                }
            }
            I18n ret = (I18n)buffer.foldLeft((Object)new I18n(Predef$.MODULE$.Map().empty()), (Function2 & Serializable & scala.Serializable)(acc, e) -> acc.$plus$plus(e));
            this.cache().update((Object)language, (Object)ret);
            i18n = ret;
        }
        return i18n;
    }

    public synchronized void clear() {
        this.cache().clear();
    }

    public void remove(String language) {
        PoLoader$ poLoader$ = this;
        synchronized (poLoader$) {
            this.cache().remove((Object)language);
        }
    }

    public void reload(String language) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info(new StringBuilder(28).append("Reload po file of language: ").append(language).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.remove(language);
        this.get(language);
    }

    private void watch() {
        List searchDirs = (List)((List)Discoverer$.MODULE$.containers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isDirectory()))).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new File(this.DEV_RESOURCES_DIR()), (List)Nil$.MODULE$), List$.MODULE$.canBuildFrom());
        searchDirs.foreach((Function1 & Serializable & scala.Serializable)dir -> {
            Function0<BoxedUnit> function0;
            File withI18n = new File((File)dir, "i18n");
            if (withI18n.exists() && withI18n.isDirectory()) {
                BoxedUnit boxedUnit;
                Path i18nPath = withI18n.toPath();
                if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                    package$.MODULE$.Log().underlying().info(new StringBuilder(21).append("Monitor po files in: ").append(i18nPath).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                function0 = FileMonitor$.MODULE$.monitor(i18nPath, (Function3<WatchEvent.Kind<Path>, Path, Function0<BoxedUnit>, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(x$2, path, x$3) -> {
                    PoLoader$.$anonfun$watch$3(x$2, path, x$3);
                    return BoxedUnit.UNIT;
                });
            } else {
                function0 = BoxedUnit.UNIT;
            }
            return function0;
        });
    }

    public static final /* synthetic */ void $anonfun$watch$3(WatchEvent.Kind x$2, Path path, Function0 x$3) {
        block0: {
            String fileName = ((Object)path.getFileName()).toString();
            if (!fileName.endsWith(".po")) break block0;
            String language = fileName.substring(0, fileName.length() - ".po".length());
            MODULE$.reload(language);
        }
    }

    private PoLoader$() {
        MODULE$ = this;
        this.DEV_RESOURCES_DIR = "src/main/resources";
        this.cache = Map$.MODULE$.empty();
        this.watch();
    }
}

