/*
 * Decompiled with CFR 0.152.
 */
package xitrum.handler.outbound;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.io.Serializable;
import java.util.Map;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.SortedMap;
import scala.collection.immutable.SortedMap$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import xitrum.Action;
import xitrum.Cache;
import xitrum.Config$;
import xitrum.handler.HandlerEnv;
import xitrum.routing.Route;
import xitrum.util.Gzip$;

public final class ResponseCacher$ {
    public static ResponseCacher$ MODULE$;

    static {
        new ResponseCacher$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldCache(HandlerEnv env) {
        Route route = env.route();
        FullHttpResponse response = env.response();
        if (route == null) return false;
        if (route.cacheSecs() == 0) return false;
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (httpResponseStatus == null) {
            if (httpResponseStatus2 != null) {
                return false;
            }
        } else if (!httpResponseStatus.equals(httpResponseStatus2)) return false;
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)response)) return false;
        return true;
    }

    public void cacheResponse(HandlerEnv env) {
        block0: {
            Class<? extends Action> actionClass = env.route().klass();
            Map<String, Seq<String>> urlParams = env.urlParams();
            boolean gzipped = Gzip$.MODULE$.isAccepted((HttpRequest)env.request());
            String key = this.makeCacheKey(actionClass, urlParams, gzipped);
            Cache cache = Config$.MODULE$.xitrum().cache();
            if (cache.isDefinedAt(key)) break block0;
            FullHttpResponse response = env.response();
            Tuple3<Object, Tuple2<String, String>[], byte[]> cachedResponse = this.serializeResponse(gzipped, response);
            int cacheSecs = env.route().cacheSecs();
            int positiveCacheSecs = cacheSecs < 0 ? -cacheSecs : cacheSecs;
            cache.putSecondIfAbsent(key, cachedResponse, positiveCacheSecs);
        }
    }

    public Option<FullHttpResponse> getCachedResponse(HandlerEnv env) {
        Class<? extends Action> actionClass = env.route().klass();
        Map<String, Seq<String>> urlParams = env.urlParams();
        boolean gzipped = Gzip$.MODULE$.isAccepted((HttpRequest)env.request());
        String key = this.makeCacheKey(actionClass, urlParams, gzipped);
        Cache cache = Config$.MODULE$.xitrum().cache();
        return cache.getAs(key).map((Function1 & Serializable & scala.Serializable)cachedResponse -> MODULE$.deserializeToResponse((Tuple3<Object, Tuple2<String, String>[], byte[]>)cachedResponse));
    }

    public void removeCachedResponse(Class<Action> actionClass, Map<String, Seq<String>> urlParams) {
        Cache cache = Config$.MODULE$.xitrum().cache();
        String keyTrue = this.makeCacheKey(actionClass, urlParams, true);
        cache.remove(keyTrue);
        String keyFalse = this.makeCacheKey(actionClass, urlParams, false);
        cache.remove(keyFalse);
    }

    public void removeCachedResponse(Class<Action> actionClass, Seq<Tuple2<String, Object>> urlParams) {
        Map params = Map$.MODULE$.empty();
        urlParams.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Object v = tuple2._2();
            Map map = (Map)params.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)new .colon.colon((Object)v.toString(), (List)Nil$.MODULE$)));
            return map;
        });
        this.removeCachedResponse(actionClass, (Map<String, Seq<String>>)params);
    }

    private Tuple3<Object, Tuple2<String, String>[], byte[]> serializeResponse(boolean gzipAccepted, FullHttpResponse response) {
        int status = response.status().code();
        byte[] bytes = Gzip$.MODULE$.tryCompressBigTextualResponse(gzipAccepted, response, true);
        java.util.List list = response.headers().entries();
        int size = list.size();
        Tuple2[] ret = new Tuple2[size];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Map.Entry m = (Map.Entry)list.get(i);
            ret$1[i] = new Tuple2(m.getKey(), m.getValue());
        });
        Tuple2[] headers = ret;
        return new Tuple3((Object)BoxesRunTime.boxToInteger((int)status), (Object)headers, (Object)bytes);
    }

    private FullHttpResponse deserializeToResponse(Tuple3<Object, Tuple2<String, String>[], byte[]> cachedResponse) {
        Tuple3<Object, Tuple2<String, String>[], byte[]> tuple3 = cachedResponse;
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        int status = BoxesRunTime.unboxToInt((Object)tuple3._1());
        Tuple2[] headers = (Tuple2[])tuple3._2();
        byte[] bytes = (byte[])tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)status), (Object)headers, (Object)bytes);
        Tuple3 tuple33 = tuple32;
        int status2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
        Tuple2[] headers2 = (Tuple2[])tuple33._2();
        byte[] bytes2 = (byte[])tuple33._3();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)status2), Unpooled.wrappedBuffer((byte[])bytes2));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headers2)).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ResponseCacher$.$anonfun$deserializeToResponse$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            HttpHeaders httpHeaders = response.headers().add(k, (Object)v);
            return httpHeaders;
        });
        return response;
    }

    private String makeCacheKey(Class<?> actionClass, Map<String, Seq<String>> urlParams, boolean gzipped) {
        SortedMap sortedMap = SortedMap$.MODULE$.empty((Ordering)Ordering.String$.MODULE$).$plus$plus(urlParams);
        String key = new StringBuilder(20).append("xitrum/page-action/").append(actionClass.getName()).append("/").append(sortedMap.toString()).toString();
        return gzipped ? new StringBuilder(8).append(key).append("_gzipped").toString() : key;
    }

    public static final /* synthetic */ boolean $anonfun$deserializeToResponse$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private ResponseCacher$() {
        MODULE$ = this;
    }
}

