/*
 * Decompiled with CFR 0.152.
 */
package xitrum.handler;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import scala.runtime.BoxedUnit;
import xitrum.Config$;
import xitrum.HttpsConfig;
import xitrum.handler.RebuilableSslContext;
import xitrum.package$;

public final class RebuilableSslContext$ {
    public static RebuilableSslContext$ MODULE$;
    private final Duration CACHE_DURATION;
    private volatile RebuilableSslContext.BuiltSslContext builtSslContext;

    static {
        new RebuilableSslContext$();
    }

    private Duration CACHE_DURATION() {
        return this.CACHE_DURATION;
    }

    private RebuilableSslContext.BuiltSslContext builtSslContext() {
        return this.builtSslContext;
    }

    private void builtSslContext_$eq(RebuilableSslContext.BuiltSslContext x$1) {
        this.builtSslContext = x$1;
    }

    public SslHandler newHandler(ByteBufAllocator alloc) {
        Instant now = Instant.now();
        if (now.isAfter(this.builtSslContext().rebuildableAfter())) {
            RebuilableSslContext$ rebuilableSslContext$ = this;
            synchronized (rebuilableSslContext$) {
                if (now.isAfter(this.builtSslContext().rebuildableAfter())) {
                    String checksum = this.certFilesChecksum();
                    String string = this.builtSslContext().certFilesChecksum();
                    String string2 = checksum;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        this.builtSslContext_$eq(this.buildSslContext(false));
                    } else {
                        this.builtSslContext_$eq(this.extendSslContext(now));
                    }
                }
            }
        }
        return this.builtSslContext().sslContext().newHandler(alloc);
    }

    private RebuilableSslContext.BuiltSslContext buildSslContext(boolean firstBuild) {
        BoxedUnit boxedUnit;
        HttpsConfig https = (HttpsConfig)Config$.MODULE$.xitrum().https().get();
        SslProvider provider = https.openSSL() ? SslProvider.OPENSSL : SslProvider.JDK;
        SslContext sslContext = SslContextBuilder.forServer((File)https.certChainFile(), (File)https.keyFile()).sslProvider(provider).build();
        Instant rebuildableAfter = Instant.now().plus(this.CACHE_DURATION());
        if (firstBuild) {
            if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                package$.MODULE$.Log().underlying().info(new StringBuilder(71).append("SSL certificate files ").append(https.certChainFile()).append(" and ").append(https.keyFile()).append(" loaded, they will be reloadable in ").append(this.CACHE_DURATION()).append(", after ").append(rebuildableAfter).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
            package$.MODULE$.Log().underlying().warn(new StringBuilder(73).append("SSL certificate files ").append(https.certChainFile()).append(" and ").append(https.keyFile()).append(" reloaded, they will be reloadable in ").append(this.CACHE_DURATION()).append(", after ").append(rebuildableAfter).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String checksum = this.certFilesChecksum();
        return new RebuilableSslContext.BuiltSslContext(sslContext, rebuildableAfter, checksum);
    }

    private RebuilableSslContext.BuiltSslContext extendSslContext(Instant now) {
        BoxedUnit boxedUnit;
        HttpsConfig https = (HttpsConfig)Config$.MODULE$.xitrum().https().get();
        Instant rebuildableAfter = now.plus(this.CACHE_DURATION());
        if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
            package$.MODULE$.Log().underlying().warn(new StringBuilder(77).append("SSL certificate files ").append(https.certChainFile()).append(" and ").append(https.keyFile()).append(" not modified, they will be reloadable in ").append(this.CACHE_DURATION()).append(", after ").append(rebuildableAfter).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        RebuilableSslContext.BuiltSslContext qual$1 = this.builtSslContext();
        Instant x$1 = rebuildableAfter;
        SslContext x$2 = qual$1.copy$default$1();
        String x$3 = qual$1.copy$default$3();
        return qual$1.copy(x$2, x$1, x$3);
    }

    private String certFilesChecksum() {
        HttpsConfig https = (HttpsConfig)Config$.MODULE$.xitrum().https().get();
        return new StringBuilder(1).append(better.files.package$.MODULE$.FileExtensions(https.certChainFile()).toScala().md5()).append("-").append(better.files.package$.MODULE$.FileExtensions(https.keyFile()).toScala().md5()).toString();
    }

    private RebuilableSslContext$() {
        MODULE$ = this;
        this.CACHE_DURATION = Duration.ofHours(1L);
        this.builtSslContext = this.buildSslContext(true);
    }
}

