/*
 * Decompiled with CFR 0.152.
 */
package xitrum.etag;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Map;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import xitrum.Action;
import xitrum.Config$;
import xitrum.etag.Etag;
import xitrum.etag.Etag$NotFound$;
import xitrum.util.Gzip$;
import xitrum.util.Loader$;
import xitrum.util.LocalLruCache$;
import xitrum.util.Mime$;
import xitrum.util.SeriDeseri$;

public final class Etag$ {
    public static Etag$ MODULE$;
    private final Map<Tuple2<String, Object>, Etag.Small> smallFileCache;
    private final Map<Tuple2<String, Object>, Etag.Small> gzippedSmallFileCache;

    static {
        new Etag$();
    }

    public String quote(String etag) {
        return new StringBuilder(2).append("\"").append(etag).append("\"").toString();
    }

    public void set(HttpResponse response, String etag) {
        response.headers().set((CharSequence)HttpHeaderNames.ETAG, (Object)this.quote(etag));
    }

    public String forBytes(byte[] bytes) {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.reset();
        md5.update(bytes);
        return SeriDeseri$.MODULE$.bytesToUrlSafeBase64(md5.digest());
    }

    public String forString(String string) {
        return this.forBytes(string.getBytes(Config$.MODULE$.xitrum().request().charset()));
    }

    public Etag.Result forFile(String path, Option<String> mimeo, boolean gzipped) {
        long mtime;
        Tuple2 key;
        File file = new File(path);
        if (!file.exists()) {
            return Etag$NotFound$.MODULE$;
        }
        if (file.length() > (long)Config$.MODULE$.xitrum().staticFile().maxSizeInBytesOfCachedFiles()) {
            return new Etag.TooBig(file, (Option<String>)mimeo.orElse((Function0 & Serializable & scala.Serializable)() -> Mime$.MODULE$.get(path)));
        }
        Map<Tuple2<String, Object>, Etag.Small> cache = gzipped ? this.gzippedSmallFileCache : this.smallFileCache;
        Etag.Small value = cache.get(key = new Tuple2((Object)path, (Object)BoxesRunTime.boxToLong((long)(mtime = file.lastModified()))));
        if (value != null) {
            return value;
        }
        byte[] bytes = Loader$.MODULE$.bytesFromFile(path);
        if (bytes == null) {
            return Etag$NotFound$.MODULE$;
        }
        String etag = this.forBytes(bytes);
        Etag.Small small = new Etag.Small(bytes, etag, (Option<String>)mimeo.orElse((Function0 & Serializable & scala.Serializable)() -> Mime$.MODULE$.get(path)), false);
        Etag.Small smaller = gzipped ? this.compressBigTextualFile(small) : small;
        Map<Tuple2<String, Object>, Etag.Small> map = cache;
        synchronized (map) {
            cache.put((Tuple2<String, Object>)key, smaller);
        }
        return smaller;
    }

    public Etag.Result forResource(String path, Option<String> mimeo, boolean gzipped) {
        Tuple2 key;
        Map<Tuple2<String, Object>, Etag.Small> cache = gzipped ? this.gzippedSmallFileCache : this.smallFileCache;
        Etag.Small value = cache.get(key = new Tuple2((Object)new StringBuilder(10).append("[resource]").append(path).toString(), (Object)BoxesRunTime.boxToLong((long)0L)));
        if (value != null) {
            return value;
        }
        byte[] bytes = Loader$.MODULE$.bytesFromClasspath(path);
        if (bytes == null) {
            return Etag$NotFound$.MODULE$;
        }
        String etag = this.forBytes(bytes);
        Etag.Small small = new Etag.Small(bytes, etag, (Option<String>)mimeo.orElse((Function0 & Serializable & scala.Serializable)() -> Mime$.MODULE$.get(path)), false);
        Etag.Small smaller = gzipped ? this.compressBigTextualFile(small) : small;
        Map<Tuple2<String, Object>, Etag.Small> map = cache;
        synchronized (map) {
            cache.put((Tuple2<String, Object>)key, smaller);
        }
        return smaller;
    }

    public boolean areEtagsIdentical(HttpRequest request, String etag) {
        String string = request.headers().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH);
        String string2 = this.quote(etag);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public boolean respondIfEtagsIdentical(Action action, String etag) {
        boolean bl;
        FullHttpRequest request = action.request();
        FullHttpResponse response = action.response();
        if (this.areEtagsIdentical((HttpRequest)request, etag)) {
            response.setStatus(HttpResponseStatus.NOT_MODIFIED);
            response.content().clear();
            action.respond();
            bl = true;
        } else {
            this.set((HttpResponse)response, etag);
            bl = false;
        }
        return bl;
    }

    private Etag.Small compressBigTextualFile(Etag.Small small) {
        Tuple2 tuple2;
        Tuple2 tuple22 = tuple2 = small.mimeo().isDefined() && Mime$.MODULE$.isTextual((String)small.mimeo().get()) ? new Tuple2((Object)Gzip$.MODULE$.compress(small.bytes()), (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)small.bytes(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        byte[] bytes2 = (byte[])tuple2._1();
        boolean gzipped = tuple2._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)bytes2, (Object)BoxesRunTime.boxToBoolean((boolean)gzipped));
        Tuple2 tuple24 = tuple23;
        byte[] bytes22 = (byte[])tuple24._1();
        boolean gzipped2 = tuple24._2$mcZ$sp();
        return new Etag.Small(bytes22, small.etag(), small.mimeo(), gzipped2);
    }

    private Etag$() {
        MODULE$ = this;
        this.smallFileCache = LocalLruCache$.MODULE$.apply(Config$.MODULE$.xitrum().staticFile().maxNumberOfCachedFiles());
        this.gzippedSmallFileCache = LocalLruCache$.MODULE$.apply(Config$.MODULE$.xitrum().staticFile().maxNumberOfCachedFiles());
    }
}

