/*
 * Decompiled with CFR 0.152.
 */
package xitrum.handler;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import xitrum.Config$;

public final class NetOption$ {
    public static NetOption$ MODULE$;

    static {
        new NetOption$();
    }

    public void bind(String service, ServerBootstrap bootstrap, int port, Seq<EventLoopGroup> groups) {
        InetSocketAddress inetSocketAddress;
        Option<String> ic;
        this.setOptions(bootstrap);
        Option<String> option = ic = Config$.MODULE$.xitrum().interface();
        if (None$.MODULE$.equals(option)) {
            inetSocketAddress = new InetSocketAddress(port);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String hostnameOrIp = (String)some.value();
            inetSocketAddress = new InetSocketAddress(hostnameOrIp, port);
        } else {
            throw new MatchError(option);
        }
        InetSocketAddress addr = inetSocketAddress;
        ChannelFuture portOpenFuture = bootstrap.bind((SocketAddress)addr);
        portOpenFuture.awaitUninterruptibly();
        if (!portOpenFuture.isSuccess()) {
            String string;
            Option<String> option2 = ic;
            if (None$.MODULE$.equals(option2)) {
                string = new StringOps(Predef$.MODULE$.augmentString("Could not open port %d for %s server. Check to see if there's another process already running on that port.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)port), service}));
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                String hostnameOrIp = (String)some.value();
                string = new StringOps(Predef$.MODULE$.augmentString("Could not open %s:%d for %s server. Check to see if there's another process already running at that address.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hostnameOrIp, BoxesRunTime.boxToInteger((int)port), service}));
            } else {
                throw new MatchError(option2);
            }
            String msg = string;
            groups.foreach((Function1 & Serializable & scala.Serializable)x$1 -> x$1.shutdownGracefully());
            Config$.MODULE$.exitOnStartupError(msg, portOpenFuture.cause());
            return;
        }
        portOpenFuture.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(groups){
            private final Seq groups$1;

            public void operationComplete(ChannelFuture future) {
                this.groups$1.foreach((Function1 & Serializable & scala.Serializable)x$2 -> x$2.shutdownGracefully());
            }
            {
                this.groups$1 = groups$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(io.netty.channel.EventLoopGroup )}, serializedLambda);
            }
        });
    }

    private void setOptions(ServerBootstrap bootstrap) {
        bootstrap.option(ChannelOption.SO_REUSEADDR, (Object)Boolean.TRUE);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE);
        bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    private NetOption$() {
        MODULE$ = this;
    }
}

