/*
 * Decompiled with CFR 0.152.
 */
package xitrum;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import xitrum.XitrumConfig;
import xitrum.package$;
import xitrum.routing.DiscoveredAcc;
import xitrum.routing.RouteCollection;
import xitrum.routing.RouteCollection$;
import xitrum.routing.RouteCollector$;

public final class Config$ {
    public static Config$ MODULE$;
    private final String ACTOR_SYSTEM_NAME;
    private final ActorSystem actorSystem;
    private final int BIG_TEXTUAL_RESPONSE_SIZE_IN_KB;
    private final String DEFAULT_SECURE_KEY;
    private final boolean productionMode;
    private final Config application;
    private final XitrumConfig xitrum;
    private final String baseUrl;
    private final File ROUTES_CACHE;
    private RouteCollection routes;

    static {
        new Config$();
    }

    private void addConfigDirectoryToClasspath() {
        String configDirPath = new StringBuilder(6).append(package$.MODULE$.root()).append(File.separator).append("config").toString();
        File configDir = new File(configDirPath);
        if (!configDir.exists()) {
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL appUrl = cl.getResource("application.conf");
        if (appUrl != null) {
            return;
        }
        this.findURLClassLoader(cl).foreach((Function1 & Serializable & scala.Serializable)urlCl -> {
            URL configDirUrl = configDir.toURI().toURL();
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            return method.invoke(urlCl, configDirUrl);
        });
    }

    private Option<URLClassLoader> findURLClassLoader(ClassLoader cl) {
        Some some;
        block2: {
            while (true) {
                ClassLoader classLoader;
                if ((classLoader = cl) instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                    some = new Some((Object)uRLClassLoader);
                    break block2;
                }
                ClassLoader parent = cl.getParent();
                if (parent == null) break;
                cl = parent;
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public String ACTOR_SYSTEM_NAME() {
        return this.ACTOR_SYSTEM_NAME;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public int BIG_TEXTUAL_RESPONSE_SIZE_IN_KB() {
        return this.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB;
    }

    public boolean productionMode() {
        return this.productionMode;
    }

    public Config application() {
        return this.application;
    }

    public XitrumConfig xitrum() {
        return this.xitrum;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String withBaseUrl(String path) {
        return this.baseUrl().isEmpty() ? (path.isEmpty() ? "/" : (path.startsWith("/") ? path : new StringBuilder(1).append("/").append(path).toString())) : (path.isEmpty() ? this.baseUrl() : (path.startsWith("/") ? new StringBuilder(0).append(this.baseUrl()).append(path).toString() : new StringBuilder(1).append(this.baseUrl()).append("/").append(path).toString()));
    }

    public void warnOnDefaultSecureKey() {
        block2: {
            BoxedUnit boxedUnit;
            String string = this.xitrum().session().secureKey();
            String string2 = this.DEFAULT_SECURE_KEY;
            if (string != null ? !string.equals(string2) : string2 != null) break block2;
            if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
                package$.MODULE$.Log().underlying().warn("*** For security, change secureKey in config/xitrum.conf to your own! ***");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void exitOnStartupError(String msg) {
        this.exitOnStartupError(msg, (Option<Throwable>)None$.MODULE$);
    }

    public void exitOnStartupError(String msg, Throwable e) {
        this.exitOnStartupError(msg, (Option<Throwable>)new Some((Object)e));
    }

    private void exitOnStartupError(String msg, Option<Throwable> eo) {
        BoxedUnit boxedUnit;
        eo.foreach((Function1 & Serializable & scala.Serializable)e -> {
            Config$.$anonfun$exitOnStartupError$1(msg, e);
            return BoxedUnit.UNIT;
        });
        if (package$.MODULE$.Log().underlying().isErrorEnabled()) {
            package$.MODULE$.Log().underlying().error("Xitrum could not start because of the above error. Xitrum will now stop the current process.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        System.exit(-1);
    }

    public RouteCollection routes() {
        return this.routes;
    }

    public void routes_$eq(RouteCollection x$1) {
        this.routes = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public RouteCollection loadRoutes(ClassLoader cl, boolean quiet) {
        void var3_3;
        block0: {
            RouteCollection ret = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, false);
            if (!this.xitrum().metrics().isEmpty()) break block0;
            ret.removeByPrefix("xitrum/metrics");
        }
        return var3_3;
    }

    private RouteCollection loadRouteCacheFileOrRecollectWithRetry(ClassLoader cl, boolean quiet, boolean retried) {
        RouteCollection routeCollection;
        block14: {
            try {
                BoxedUnit boxedUnit;
                if (!quiet) {
                    if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                        package$.MODULE$.Log().underlying().info(new StringBuilder(28).append("Load ").append(this.ROUTES_CACHE).append(" or recollect routes...").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                DiscoveredAcc discoveredAcc = RouteCollector$.MODULE$.deserializeCacheFileOrRecollect(this.ROUTES_CACHE, cl);
                String string = discoveredAcc.xitrumVersion();
                String string2 = package$.MODULE$.version().toString();
                if (string == null ? string2 != null : !string.equals(string2)) {
                    BoxedUnit boxedUnit2;
                    if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                        package$.MODULE$.Log().underlying().info(new StringBuilder(44).append("Xitrum version changed. Delete ").append(this.ROUTES_CACHE).append(" and retry...").toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    this.ROUTES_CACHE.delete();
                    routeCollection = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, true);
                    break block14;
                }
                boolean withSwagger = this.xitrum().swaggerApiVersion().isDefined();
                routeCollection = RouteCollection$.MODULE$.fromSerializable(discoveredAcc, withSwagger);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (retried) {
                        this.exitOnStartupError("Could not collect routes", e);
                        throw e;
                    }
                    if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                        package$.MODULE$.Log().underlying().info(new StringBuilder(36).append("Could not load ").append(this.ROUTES_CACHE).append(", delete and retry...").toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw throwable;
                }
                this.ROUTES_CACHE.delete();
                RouteCollection routeCollection2 = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, true);
                routeCollection = routeCollection2;
            }
        }
        return routeCollection;
    }

    private final Config liftedTree1$1() {
        Config config;
        try {
            config = ConfigFactory.load((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)"application");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.exitOnStartupError("Could not load config/application.conf. For an example, see https://github.com/xitrum-framework/xitrum-new/blob/master/config/application.conf", e);
                throw e;
            }
            throw throwable;
        }
        return config;
    }

    private final XitrumConfig liftedTree2$1() {
        XitrumConfig xitrumConfig;
        try {
            xitrumConfig = new XitrumConfig(this.application().getConfig("xitrum"));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.exitOnStartupError("Could not load config/xitrum.conf. For an example, see https://github.com/xitrum-framework/xitrum-new/blob/master/config/xitrum.conf", e);
                throw e;
            }
            throw throwable;
        }
        return xitrumConfig;
    }

    public static final /* synthetic */ void $anonfun$exitOnStartupError$1(String msg$1, Throwable e) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isErrorEnabled()) {
            package$.MODULE$.Log().underlying().error(msg$1, e);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private Config$() {
        MODULE$ = this;
        this.addConfigDirectoryToClasspath();
        this.ACTOR_SYSTEM_NAME = "xitrum";
        this.actorSystem = ActorSystem$.MODULE$.apply(this.ACTOR_SYSTEM_NAME());
        this.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB = 1;
        this.DEFAULT_SECURE_KEY = "ajconghoaofuxahoi92chunghiaujivietnamlasdoclapjfltudoil98hanhphucup8";
        String string = System.getProperty("xitrum.mode");
        String string2 = "production";
        this.productionMode = !(string != null ? !string.equals(string2) : string2 != null);
        this.application = this.liftedTree1$1();
        this.xitrum = this.liftedTree2$1();
        this.baseUrl = (String)this.xitrum().reverseProxy().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.baseUrl()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.ROUTES_CACHE = new File(this.xitrum().tmpDir(), "routes.cache");
        this.routes = this.loadRoutes(Thread.currentThread().getContextClassLoader(), false);
    }
}

