/*
 * Decompiled with CFR 0.152.
 */
package xitrum.handler;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.SortedMap;
import nl.grons.metrics.scala.Histogram;
import scala.Function0;
import scala.Option$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import xitrum.Action;
import xitrum.Config$;
import xitrum.MetricsConfig;
import xitrum.action.Net$;
import xitrum.handler.HandlerEnv;
import xitrum.package$;
import xitrum.scope.request.RequestEnv$;
import xitrum.sockjs.SockJsAction;

public final class AccessLog$ {
    public static AccessLog$ MODULE$;
    private final String LAST_EXECUTION_TIME_GAUGE;
    private final String EXECUTION_TIME_HISTOGRAM;
    private final Map<String, long[]> lastExecutionTimeMap;

    static {
        new AccessLog$();
    }

    public void logFlashSocketPolicyFileAccess(SocketAddress remoteAddress) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info(Net$.MODULE$.clientIp(remoteAddress) + " (flash socket policy file)");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logStaticFileAccess(SocketAddress remoteAddress, HttpRequest request, HttpResponse response) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info(Net$.MODULE$.remoteIp(remoteAddress, request) + " " + request.method() + " " + request.uri() + " -> " + response.status().code() + " (static file)");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logResourceInJarAccess(SocketAddress remoteAddress, HttpRequest request, HttpResponse response) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info(Net$.MODULE$.remoteIp(remoteAddress, request) + " " + request.method() + " " + request.uri() + " -> " + response.status().code() + " (JAR resource)");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logActionAccess(Action action, long beginTimestamp, int cacheSecs, boolean hit, Throwable e) {
        BoxedUnit boxedUnit;
        if (e == null) {
            BoxedUnit boxedUnit2;
            if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                package$.MODULE$.Log().underlying().info(this.msgWithTime(action, beginTimestamp) + this.extraInfo(action, cacheSecs, hit));
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else if (package$.MODULE$.Log().underlying().isErrorEnabled()) {
            package$.MODULE$.Log().underlying().error("Dispatch error " + this.msgWithTime(action, beginTimestamp) + this.extraInfo(action, cacheSecs, hit), e);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Throwable logActionAccess$default$5() {
        return null;
    }

    public void logWebSocketAccess(Action action, long beginTimestamp) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info(this.msgWithTime(action, beginTimestamp) + this.extraInfo(action, 0, false));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void logOPTIONS(HttpRequest request) {
        BoxedUnit boxedUnit;
        if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
            package$.MODULE$.Log().underlying().info("OPTIONS " + request.uri());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String LAST_EXECUTION_TIME_GAUGE() {
        return this.LAST_EXECUTION_TIME_GAUGE;
    }

    public String EXECUTION_TIME_HISTOGRAM() {
        return this.EXECUTION_TIME_HISTOGRAM;
    }

    private Map<String, long[]> lastExecutionTimeMap() {
        return this.lastExecutionTimeMap;
    }

    private String msgWithTime(Action action, long beginTimestamp) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        BoxedUnit boxedUnit5;
        long endTimestamp = System.currentTimeMillis();
        long dt = endTimestamp - beginTimestamp;
        HandlerEnv env = action.handlerEnv();
        this.takeActionExecutionTimeMetrics(action, beginTimestamp, dt);
        StringBuilder b = new StringBuilder();
        b.append(action.remoteIp());
        b.append(" ");
        b.append((Object)action.request().method());
        b.append(" ");
        b.append(action.request().uri());
        b.append(" -> ");
        b.append(action.getClass().getName());
        if (env.queryParams().nonEmpty()) {
            b.append(", queryParams: ");
            boxedUnit5 = b.append(RequestEnv$.MODULE$.inspectParamsWithFilter(env.queryParams()));
        } else {
            boxedUnit5 = BoxedUnit.UNIT;
        }
        if (env.bodyTextParams().nonEmpty()) {
            b.append(", bodyTextParams: ");
            boxedUnit4 = b.append(RequestEnv$.MODULE$.inspectParamsWithFilter(env.bodyTextParams()));
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        if (env.pathParams().nonEmpty()) {
            b.append(", pathParams: ");
            boxedUnit3 = b.append(RequestEnv$.MODULE$.inspectParamsWithFilter(env.pathParams()));
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        if (env.bodyFileParams().nonEmpty()) {
            b.append(", bodyFileParams: ");
            boxedUnit2 = b.append(RequestEnv$.MODULE$.inspectParamsWithFilter(env.bodyFileParams()));
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (action.isDoneResponding()) {
            b.append(" -> ");
            boxedUnit = b.append(action.response().status().code());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        b.append(", ");
        b.append(dt);
        b.append(" [ms]");
        return b.toString();
    }

    /*
     * Unable to fully structure code
     */
    private void takeActionExecutionTimeMetrics(Action action, long beginTimestamp, long executionTime) {
        block2: {
            if (!(action instanceof SockJsAction)) ** GOTO lbl-1000
            v0 = ((SockJsAction)action).pathPrefix();
            var7_4 = "xitrum/metrics/channel";
            if (!(v0 != null ? v0.equals(var7_4) == false : var7_4 != null)) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = isSockJSMetricsChannelClient = false;
            }
            if (!Config$.MODULE$.xitrum().metrics().isDefined() || !((MetricsConfig)Config$.MODULE$.xitrum().metrics().get()).actions() || isSockJSMetricsChannelClient) break block2;
            actionClassName = action.getClass().getName();
            this.takeActionExecutionTimeHistogram(actionClassName, executionTime);
            this.takeActionExecutionTimeHistogram(this.EXECUTION_TIME_HISTOGRAM(), executionTime);
            this.lastExecutionTimeMap().update((Object)actionClassName, (Object)new long[]{beginTimestamp, executionTime});
            this.lastExecutionTimeMap().update((Object)this.EXECUTION_TIME_HISTOGRAM(), (Object)new long[]{beginTimestamp, executionTime});
        }
    }

    private void takeActionExecutionTimeHistogram(String name, long executionTime) {
        SortedMap histograms = package$.MODULE$.Metrics().registry().getHistograms();
        Histogram histogram = (Histogram)Option$.MODULE$.apply((Object)((Histogram)histograms.get(name))).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Metrics().histogram(name, package$.MODULE$.Metrics().histogram$default$2()));
        histogram.$plus$eq(executionTime);
    }

    private String extraInfo(Action action, int cacheSecs, boolean hit) {
        return cacheSecs == 0 ? (action.isDoneResponding() ? "" : " (async)") : (hit ? (cacheSecs < 0 ? " (action cache hit)" : " (page cache hit)") : (cacheSecs < 0 ? " (action cache miss)" : " (page cache miss)"));
    }

    private AccessLog$() {
        MODULE$ = this;
        this.LAST_EXECUTION_TIME_GAUGE = "lastExecutionTime";
        this.EXECUTION_TIME_HISTOGRAM = "executionTime";
        this.lastExecutionTimeMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        package$.MODULE$.Metrics().gauge(this.LAST_EXECUTION_TIME_GAUGE(), package$.MODULE$.Metrics().gauge$default$2(), (Function0 & Serializable & scala.Serializable)() -> (Tuple2[])this.lastExecutionTimeMap().toArray(ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

