/*
 * Decompiled with CFR 0.152.
 */
package xitrum;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;
import xitrum.ReverseProxyConfig;
import xitrum.XitrumConfig;
import xitrum.package$;
import xitrum.routing.DiscoveredAcc;
import xitrum.routing.RouteCollection;
import xitrum.routing.RouteCollection$;
import xitrum.routing.RouteCollector$;

public final class Config$ {
    public static final Config$ MODULE$;
    private final String ACTOR_SYSTEM_NAME;
    private final ActorSystem actorSystem;
    private final int BIG_TEXTUAL_RESPONSE_SIZE_IN_KB;
    private final String DEFAULT_SECURE_KEY;
    private final boolean productionMode;
    private final Config application;
    private final XitrumConfig xitrum;
    private final String baseUrl;
    private final File ROUTES_CACHE;
    private RouteCollection routes;

    static {
        new Config$();
    }

    private void addConfigDirectoryToClasspath() {
        String configDirPath = new StringBuilder().append((Object)package$.MODULE$.root()).append((Object)File.separator).append((Object)"config").toString();
        File configDir = new File(configDirPath);
        if (configDir.exists()) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            URL appUrl = cl.getResource("application.conf");
            if (appUrl == null) {
                this.findURLClassLoader(cl).foreach((Function1)new Serializable(configDir){
                    public static final long serialVersionUID = 0L;
                    private final File configDir$1;

                    public final Object apply(URLClassLoader urlCl) {
                        URL configDirUrl = this.configDir$1.toURI().toURL();
                        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        method.setAccessible(true);
                        return method.invoke((Object)urlCl, configDirUrl);
                    }
                    {
                        this.configDir$1 = configDir$1;
                    }
                });
                return;
            }
            return;
        }
    }

    private Option<URLClassLoader> findURLClassLoader(ClassLoader cl) {
        while (true) {
            ClassLoader parent;
            block5: {
                Some some;
                block4: {
                    block3: {
                        if (!(cl instanceof URLClassLoader)) break block3;
                        some = new Some((Object)((URLClassLoader)cl));
                        break block4;
                    }
                    parent = cl.getParent();
                    if (parent != null) break block5;
                    some = None$.MODULE$;
                }
                return some;
            }
            cl = parent;
        }
    }

    public String ACTOR_SYSTEM_NAME() {
        return this.ACTOR_SYSTEM_NAME;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public int BIG_TEXTUAL_RESPONSE_SIZE_IN_KB() {
        return this.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB;
    }

    public boolean productionMode() {
        return this.productionMode;
    }

    public Config application() {
        return this.application;
    }

    public XitrumConfig xitrum() {
        return this.xitrum;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String withBaseUrl(String path) {
        return this.baseUrl().isEmpty() ? (path.isEmpty() ? "/" : (path.startsWith("/") ? path : new StringBuilder().append((Object)"/").append((Object)path).toString())) : (path.isEmpty() ? this.baseUrl() : (path.startsWith("/") ? new StringBuilder().append((Object)this.baseUrl()).append((Object)path).toString() : new StringBuilder().append((Object)this.baseUrl()).append((Object)"/").append((Object)path).toString()));
    }

    public void warnOnDefaultSecureKey() {
        String string = this.xitrum().session().secureKey();
        String string2 = this.DEFAULT_SECURE_KEY;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            BoxedUnit boxedUnit;
            if (package$.MODULE$.Log().underlying().isWarnEnabled()) {
                package$.MODULE$.Log().underlying().warn("*** For security, change secureKey in config/xitrum.conf to your own! ***");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void exitOnStartupError(String msg) {
        this.exitOnStartupError(msg, (Option<Throwable>)None$.MODULE$);
    }

    public void exitOnStartupError(String msg, Throwable e) {
        this.exitOnStartupError(msg, (Option<Throwable>)new Some((Object)e));
    }

    private void exitOnStartupError(String msg, Option<Throwable> eo) {
        BoxedUnit boxedUnit;
        eo.foreach((Function1)new Serializable(msg){
            public static final long serialVersionUID = 0L;
            private final String msg$1;

            public final void apply(Throwable e) {
                BoxedUnit boxedUnit;
                if (package$.MODULE$.Log().underlying().isErrorEnabled()) {
                    package$.MODULE$.Log().underlying().error(this.msg$1, e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                this.msg$1 = msg$1;
            }
        });
        if (package$.MODULE$.Log().underlying().isErrorEnabled()) {
            package$.MODULE$.Log().underlying().error("Xitrum could not start because of the above error. Xitrum will now stop the current process.");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        System.exit(-1);
    }

    public RouteCollection routes() {
        return this.routes;
    }

    public void routes_$eq(RouteCollection x$1) {
        this.routes = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public RouteCollection loadRoutes(ClassLoader cl, boolean quiet) {
        void var3_3;
        RouteCollection ret = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, false);
        if (this.xitrum().metrics().isEmpty()) {
            ret.removeByPrefix("xitrum/metrics");
        }
        return var3_3;
    }

    private RouteCollection loadRouteCacheFileOrRecollectWithRetry(ClassLoader cl, boolean quiet, boolean retried) {
        RouteCollection routeCollection;
        try {
            BoxedUnit boxedUnit;
            if (quiet) {
                boxedUnit = BoxedUnit.UNIT;
            } else if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                package$.MODULE$.Log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Load ", " or recollect routes..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ROUTES_CACHE})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            DiscoveredAcc discoveredAcc = RouteCollector$.MODULE$.deserializeCacheFileOrRecollect(this.ROUTES_CACHE, cl);
            String string = discoveredAcc.xitrumVersion();
            String string2 = package$.MODULE$.version().toString();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                boolean withSwagger = this.xitrum().swaggerApiVersion().isDefined();
                routeCollection = RouteCollection$.MODULE$.fromSerializable(discoveredAcc, withSwagger);
            } else {
                BoxedUnit boxedUnit2;
                if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                    package$.MODULE$.Log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Xitrum version changed. Delete ", " and retry..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ROUTES_CACHE})));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.ROUTES_CACHE.delete();
                routeCollection = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, true);
            }
        }
        catch (Throwable throwable) {
            RouteCollection routeCollection2;
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (retried) {
                this.exitOnStartupError("Could not collect routes", e);
                throw e;
            }
            if (package$.MODULE$.Log().underlying().isInfoEnabled()) {
                package$.MODULE$.Log().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not load ", ", delete and retry..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ROUTES_CACHE})));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.ROUTES_CACHE.delete();
            routeCollection = routeCollection2 = this.loadRouteCacheFileOrRecollectWithRetry(cl, quiet, true);
        }
        return routeCollection;
    }

    private final Config liftedTree1$1() {
        try {
            return ConfigFactory.load((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)"application");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.exitOnStartupError("Could not load config/application.conf. For an example, see https://github.com/xitrum-framework/xitrum-new/blob/master/config/application.conf", e);
            throw e;
        }
    }

    private final XitrumConfig liftedTree2$1() {
        try {
            return new XitrumConfig(this.application().getConfig("xitrum"));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.exitOnStartupError("Could not load config/xitrum.conf. For an example, see https://github.com/xitrum-framework/xitrum-new/blob/master/config/xitrum.conf", e);
            throw e;
        }
    }

    private Config$() {
        MODULE$ = this;
        this.addConfigDirectoryToClasspath();
        this.ACTOR_SYSTEM_NAME = "xitrum";
        this.actorSystem = ActorSystem$.MODULE$.apply(this.ACTOR_SYSTEM_NAME());
        this.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB = 1;
        this.DEFAULT_SECURE_KEY = "ajconghoaofuxahoi92chunghiaujivietnamlasdoclapjfltudoil98hanhphucup8";
        String string = System.getProperty("xitrum.mode");
        String string2 = "production";
        this.productionMode = !(string != null ? !string.equals(string2) : string2 != null);
        this.application = this.liftedTree1$1();
        this.xitrum = this.liftedTree2$1();
        this.baseUrl = (String)this.xitrum().reverseProxy().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ReverseProxyConfig x$1) {
                return x$1.baseUrl();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        this.ROUTES_CACHE = new File(this.xitrum().tmpDir(), "routes.cache");
        this.routes = this.loadRoutes(Thread.currentThread().getContextClassLoader(), false);
    }
}

