/*
 * Decompiled with CFR 0.152.
 */
package xitrum.util;

import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.util.control.NonFatal$;
import xitrum.Config$;

public final class Secure$ {
    public static final Secure$ MODULE$;
    private final String HMAC_ALGORITHM;
    private final String CRYPT_TYPE;
    private final String CRYPT_ALGORITHM;
    private final byte[] defaultKey;

    static {
        new Secure$();
    }

    public byte[] encrypt(byte[] data) {
        return this.encrypt(data, Config$.MODULE$.xitrum().session().secureKey());
    }

    public Option<byte[]> decrypt(byte[] data) {
        return this.decrypt(data, Config$.MODULE$.xitrum().session().secureKey());
    }

    public byte[] encrypt(byte[] data, String key) {
        byte[] bkey = this.makeKey(key);
        byte[] data2 = this.encryptWithoutSeal(data, bkey);
        return this.seal(data2, bkey);
    }

    public Option<byte[]> decrypt(byte[] data, String key) {
        byte[] bkey = this.makeKey(key);
        return this.unseal(data, bkey).flatMap((Function1)new Serializable(bkey){
            public static final long serialVersionUID = 0L;
            private final byte[] bkey$1;

            public final Option<byte[]> apply(byte[] data2) {
                Some some;
                try {
                    some = new Some((Object)Secure$.MODULE$.xitrum$util$Secure$$decryptWithoutSeal(data2, this.bkey$1));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    None$ none$ = None$.MODULE$;
                    some = none$;
                }
                return some;
            }
            {
                this.bkey$1 = bkey$1;
            }
        });
    }

    private byte[] makeKey(String key) {
        byte[] byArray;
        String string = key;
        String string2 = Config$.MODULE$.xitrum().session().secureKey();
        if (!(string != null ? !string.equals(string2) : string2 != null) && this.defaultKey != null) {
            byArray = this.defaultKey;
        } else {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(key.getBytes(CharsetUtil.UTF_8));
            byArray = messageDigest.digest();
        }
        return byArray;
    }

    private byte[] makeBytes(int size) {
        return new byte[size];
    }

    private byte[] hmac(byte[] data, byte[] key) {
        Mac mac = Mac.getInstance(this.HMAC_ALGORITHM);
        mac.init(new SecretKeySpec(key, this.HMAC_ALGORITHM));
        return mac.doFinal(data);
    }

    private byte[] encryptWithoutSeal(byte[] data, byte[] key) {
        Cipher cipher = Cipher.getInstance(this.CRYPT_ALGORITHM);
        SecretKeySpec secretKey = new SecretKeySpec(key, this.CRYPT_TYPE);
        byte[] iv = this.makeBytes(cipher.getBlockSize());
        cipher.init(1, (Key)secretKey, new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    public byte[] xitrum$util$Secure$$decryptWithoutSeal(byte[] data, byte[] key) {
        Cipher cipher = Cipher.getInstance(this.CRYPT_ALGORITHM);
        SecretKeySpec secretKey = new SecretKeySpec(key, this.CRYPT_TYPE);
        byte[] iv = this.makeBytes(cipher.getBlockSize());
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)secretKey, ivSpec);
        return cipher.doFinal(data);
    }

    private byte[] seal(byte[] data, byte[] key) {
        int l = data.length;
        byte[] h = this.hmac(data, key);
        ByteBuffer b = ByteBuffer.allocate(4 + l + h.length);
        b.putInt(l);
        b.put(data);
        b.put(h);
        return b.array();
    }

    private Option<byte[]> unseal(byte[] data, byte[] key) {
        Object object;
        try {
            if (data.length <= 4) {
                return None$.MODULE$;
            }
            ByteBuffer b = ByteBuffer.wrap(data);
            int l = b.getInt();
            if (l <= 0 || l >= data.length - 4) {
                return None$.MODULE$;
            }
            byte[] d = new byte[l];
            b.get(d);
            byte[] h = new byte[data.length - 4 - l];
            b.get(h);
            byte[] h2 = this.hmac(d, key);
            object = Arrays.equals(h2, h) ? new Some((Object)d) : None$.MODULE$;
        }
        catch (Throwable throwable) {
            None$ none$;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            object = none$ = None$.MODULE$;
        }
        return object;
    }

    private Secure$() {
        MODULE$ = this;
        this.HMAC_ALGORITHM = "HmacSHA256";
        this.CRYPT_TYPE = "AES";
        this.CRYPT_ALGORITHM = "AES/CBC/PKCS5Padding";
        this.defaultKey = this.makeKey(Config$.MODULE$.xitrum().session().secureKey());
    }
}

