/*
 * Decompiled with CFR 0.152.
 */
package xitrum.view;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.runtime.BoxedUnit;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.Xhtml$;
import xitrum.Action;
import xitrum.Config$;
import xitrum.etag.NotModified$;
import xitrum.handler.NoRealPipelining$;
import xitrum.handler.outbound.XSendFile$;
import xitrum.handler.outbound.XSendResource$;
import xitrum.util.ByteBufUtil$;
import xitrum.util.SeriDeseri$;

public abstract class Responder$class {
    public static boolean isDoneResponding(Action $this) {
        return $this.xitrum$view$Responder$$doneResponding();
    }

    public static void onDoneResponding(Action $this) {
    }

    /*
     * WARNING - void declaration
     */
    public static ChannelFuture respond(Action $this) {
        void var1_1;
        if ($this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent()) {
            Responder$class.throwDoubleResponseError($this, Responder$class.throwDoubleResponseError$default$1($this));
        }
        $this.setCookieAndSessionIfTouchedOnRespond();
        ChannelFuture future = $this.channel().writeAndFlush((Object)$this.handlerEnv());
        if (!(XSendFile$.MODULE$.isHeaderSet($this.response()) || XSendResource$.MODULE$.isHeaderSet($this.response()) || HttpHeaders.isTransferEncodingChunked((HttpMessage)$this.response()))) {
            NoRealPipelining$.MODULE$.if_keepAliveRequest_then_resumeReading_else_closeOnComplete((HttpRequest)$this.request(), $this.channel(), future);
        }
        $this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent_$eq(true);
        if (!HttpHeaders.isTransferEncodingChunked((HttpMessage)$this.response())) {
            $this.xitrum$view$Responder$$doneResponding_$eq(true);
            $this.onDoneResponding();
        }
        return var1_1;
    }

    public static void setChunked(Action $this) {
        HttpHeaders.setTransferEncodingChunked((HttpMessage)$this.response());
    }

    /*
     * WARNING - void declaration
     */
    public static ChannelFuture respondLastChunk(Action $this, HttpHeaders trailingHeaders) {
        LastHttpContent lastHttpContent;
        if ($this.xitrum$view$Responder$$doneResponding()) {
            Responder$class.throwDoubleResponseError($this, Responder$class.throwDoubleResponseError$default$1($this));
        }
        if (trailingHeaders.isEmpty()) {
            lastHttpContent = LastHttpContent.EMPTY_LAST_CONTENT;
        } else {
            void var3_2;
            DefaultLastHttpContent ret = new DefaultLastHttpContent();
            ret.trailingHeaders().set(trailingHeaders);
            lastHttpContent = var3_2;
        }
        LastHttpContent trailer = lastHttpContent;
        ChannelFuture future = $this.channel().writeAndFlush((Object)trailer);
        NoRealPipelining$.MODULE$.if_keepAliveRequest_then_resumeReading_else_closeOnComplete((HttpRequest)$this.request(), $this.channel(), future);
        $this.xitrum$view$Responder$$doneResponding_$eq(true);
        $this.onDoneResponding();
        return future;
    }

    public static HttpHeaders respondLastChunk$default$1(Action $this) {
        return HttpHeaders.EMPTY_HEADERS;
    }

    public static ChannelFuture respondText(Action $this, Object text, String fallbackContentType, boolean convertXmlToXhtml) {
        ChannelFuture channelFuture;
        String respondedText;
        boolean textIsXml;
        if ($this.xitrum$view$Responder$$doneResponding()) {
            Responder$class.throwDoubleResponseError($this, (Option)new Some(text));
        }
        boolean bl = textIsXml = text instanceof Node || text instanceof NodeSeq;
        String string = textIsXml && convertXmlToXhtml ? (text instanceof Node ? Xhtml$.MODULE$.toXhtml((Node)text) : Xhtml$.MODULE$.toXhtml((NodeSeq)text)) : (respondedText = text.toString());
        if (!$this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent() && !$this.response().headers().contains("Content-Type")) {
            if (fallbackContentType == null) {
                if (textIsXml) {
                    HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)new StringBuilder().append((Object)"application/xml; charset=").append((Object)Config$.MODULE$.xitrum().request().charset()).toString());
                } else {
                    HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)new StringBuilder().append((Object)"text/plain; charset=").append((Object)Config$.MODULE$.xitrum().request().charset()).toString());
                }
            } else {
                String withCharset = fallbackContentType.toLowerCase().contains("charset") ? fallbackContentType : new StringBuilder().append((Object)fallbackContentType).append((Object)"; charset=").append((Object)Config$.MODULE$.xitrum().request().charset()).toString();
                HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)withCharset);
            }
        }
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)respondedText, (Charset)Config$.MODULE$.xitrum().request().charset());
        if (HttpHeaders.isTransferEncodingChunked((HttpMessage)$this.response())) {
            Responder$class.respondHeadersOnlyForFirstChunk($this);
            channelFuture = $this.channel().writeAndFlush((Object)new DefaultHttpContent(buf));
        } else {
            ByteBufUtil$.MODULE$.writeComposite($this.response().content(), buf);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static String respondText$default$2(Action $this) {
        return null;
    }

    public static boolean respondText$default$3(Action $this) {
        return true;
    }

    public static ChannelFuture respondXml(Action $this, Object any) {
        return $this.respondText(any, "application/xml", false);
    }

    public static ChannelFuture respondHtml(Action $this, Object any) {
        return $this.respondText(any, "text/html", $this.respondText$default$3());
    }

    public static ChannelFuture respondJs(Action $this, Object any) {
        return $this.respondText(any, "application/javascript", $this.respondText$default$3());
    }

    public static ChannelFuture respondJsonText(Action $this, Object any) {
        return $this.respondText(any, "application/json", $this.respondText$default$3());
    }

    public static ChannelFuture respondJson(Action $this, Object ref) {
        String json = SeriDeseri$.MODULE$.toJson(ref);
        return $this.respondText(json, "application/json", $this.respondText$default$3());
    }

    public static ChannelFuture respondJsonP(Action $this, Object ref, String function) {
        String json = SeriDeseri$.MODULE$.toJson(ref);
        String text = new StringBuilder().append((Object)function).append((Object)"(").append((Object)json).append((Object)");\r\n").toString();
        return $this.respondJs(text);
    }

    public static ChannelFuture respondJsonPText(Action $this, Object text, String function) {
        return $this.respondJs(new StringBuilder().append((Object)function).append((Object)"(").append(text).append((Object)");\r\n").toString());
    }

    public static ChannelFuture respondView(Action $this, Function0 customLayout, Class location, Map options) {
        String string = $this.renderView((Function0<Object>)customLayout, location, (Map<String, Object>)options);
        return $this.respondText(string, "text/html", $this.respondText$default$3());
    }

    public static ChannelFuture respondView(Action $this, Function0 customLayout, Map options, Manifest evidence$1) {
        return $this.respondView((Function0<Object>)customLayout, $this.getActionClass(evidence$1), (Map<String, Object>)options);
    }

    public static ChannelFuture respondView(Action $this, Function0 customLayout, Manifest evidence$2) {
        return $this.respondView((Function0<Object>)customLayout, $this.getActionClass(evidence$2), (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public static ChannelFuture respondView(Action $this, Map options, Manifest evidence$3) {
        return $this.respondView((Function0<Object>)new Serializable($this){
            private final /* synthetic */ Action $outer;

            public final Object apply() {
                return this.$outer.layout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.getActionClass(evidence$3), (Map<String, Object>)options);
    }

    public static ChannelFuture respondView(Action $this, Manifest evidence$4) {
        return $this.respondView((Function0<Object>)new Serializable($this){
            private final /* synthetic */ Action $outer;

            public final Object apply() {
                return this.$outer.layout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, $this.getActionClass(evidence$4), (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public static ChannelFuture respondViewNoLayout(Action $this, Class location, Map options) {
        String string = $this.renderViewNoLayout(location, (Map<String, Object>)options);
        return $this.respondText(string, "text/html", $this.respondText$default$3());
    }

    public static ChannelFuture respondViewNoLayout(Action $this, Map options, Manifest evidence$5) {
        return $this.respondViewNoLayout($this.getActionClass(evidence$5), (Map<String, Object>)options);
    }

    public static ChannelFuture respondViewNoLayout(Action $this, Manifest evidence$6) {
        return $this.respondViewNoLayout($this.getActionClass(evidence$6), (Map<String, Object>)Predef$.MODULE$.Map().empty());
    }

    public static ChannelFuture respondInlineView(Action $this, Object inlineView) {
        String string = $this.renderInlineView(inlineView);
        return $this.respondText(string, "text/html", $this.respondText$default$3());
    }

    public static ChannelFuture respondBinary(Action $this, byte[] bytes) {
        return $this.respondBinary(Unpooled.wrappedBuffer((byte[])bytes));
    }

    public static ChannelFuture respondBinary(Action $this, ByteBuf byteBuf) {
        ChannelFuture channelFuture;
        if (HttpHeaders.isTransferEncodingChunked((HttpMessage)$this.response())) {
            Responder$class.respondHeadersOnlyForFirstChunk($this);
            channelFuture = $this.channel().writeAndFlush((Object)new DefaultHttpContent(byteBuf));
        } else {
            if (!$this.response().headers().contains("Content-Type")) {
                HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)"application/octet-stream");
            }
            ByteBufUtil$.MODULE$.writeComposite($this.response().content(), byteBuf);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static ChannelFuture respondFile(Action $this, String path) {
        XSendFile$.MODULE$.setHeader($this.response(), path, true);
        return $this.respond();
    }

    public static ChannelFuture respondResource(Action $this, String path) {
        XSendResource$.MODULE$.setHeader($this.response(), path, true);
        return $this.respond();
    }

    public static ChannelFuture respondEventSource(Action $this, Object data, String event) {
        BoxedUnit boxedUnit;
        if ($this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent()) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            HttpHeaders.setTransferEncodingChunked((HttpMessage)$this.response());
            HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)"text/event-stream; charset=UTF-8");
            boxedUnit = $this.respondText("\r\n", $this.respondText$default$2(), $this.respondText$default$3());
        }
        return $this.respondText($this.renderEventSource(data, event), $this.respondText$default$2(), $this.respondText$default$3());
    }

    public static String respondEventSource$default$2(Action $this) {
        return "message";
    }

    public static ChannelFuture respondDefault404Page(Action $this) {
        ChannelFuture channelFuture;
        if ($this.isAjax()) {
            $this.response().setStatus(HttpResponseStatus.NOT_FOUND);
            channelFuture = $this.jsRespond((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"alert(\"").append((Object)$this.jsEscape("Not Found")).append((Object)"\")").toString()}));
        } else {
            XSendFile$.MODULE$.set404Page($this.response(), true);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static ChannelFuture respondDefault500Page(Action $this) {
        ChannelFuture channelFuture;
        if ($this.isAjax()) {
            $this.response().setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            channelFuture = $this.jsRespond((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder().append((Object)"alert(\"").append((Object)$this.jsEscape("Internal Server Error")).append((Object)"\")").toString()}));
        } else {
            XSendFile$.MODULE$.set500Page($this.response(), true);
            channelFuture = $this.respond();
        }
        return channelFuture;
    }

    public static void setClientCacheAggressively(Action $this) {
        NotModified$.MODULE$.setClientCacheAggressively($this.response());
    }

    public static void setNoClientCache(Action $this) {
        NotModified$.MODULE$.setNoClientCache($this.response());
    }

    private static void throwDoubleResponseError(Action $this, Option texto) {
        Option option = texto;
        if (None$.MODULE$.equals(option)) {
            throw new IllegalStateException("Double response error. See stack trace to know where to fix the error.");
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Object text = some.x();
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Double response error. See stack trace to know where to fix the error. You're trying to respond: ", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{text})));
        }
        throw new MatchError((Object)option);
    }

    private static Option throwDoubleResponseError$default$1(Action $this) {
        return None$.MODULE$;
    }

    private static void respondHeadersOnlyForFirstChunk(Action $this) {
        if ($this.xitrum$view$Responder$$doneResponding()) {
            Responder$class.throwDoubleResponseError($this, Responder$class.throwDoubleResponseError$default$1($this));
        }
        if ($this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent()) {
            return;
        }
        if (!$this.response().headers().contains("Content-Type")) {
            HttpHeaders.setHeader((HttpMessage)$this.response(), (String)"Content-Type", (Object)"application/octet-stream");
        }
        HttpHeaders.removeHeader((HttpMessage)$this.response(), (String)"Content-Length");
        $this.setNoClientCache();
        $this.respond();
    }

    public static void $init$(Action $this) {
        $this.xitrum$view$Responder$$nonChunkedResponseOrFirstChunkSent_$eq(false);
        $this.xitrum$view$Responder$$doneResponding_$eq(false);
    }
}

