/*
 * Decompiled with CFR 0.152.
 */
package xitrum.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import xitrum.Config$;
import xitrum.util.ByteBufUtil$;
import xitrum.util.Mime$;

public final class Gzip$ {
    public static final Gzip$ MODULE$;
    private final byte GZIP_SIGNATURE_BYTE1;
    private final byte GZIP_SIGNATURE_BYTE2;

    static {
        new Gzip$();
    }

    private byte GZIP_SIGNATURE_BYTE1() {
        return this.GZIP_SIGNATURE_BYTE1;
    }

    private byte GZIP_SIGNATURE_BYTE2() {
        return this.GZIP_SIGNATURE_BYTE2;
    }

    public boolean isCompressed(byte[] bytes) {
        return bytes.length < 2 ? false : bytes[0] == this.GZIP_SIGNATURE_BYTE1() && bytes[1] == this.GZIP_SIGNATURE_BYTE2();
    }

    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        GZIPOutputStream g = new GZIPOutputStream(b);
        g.write(bytes);
        g.finish();
        byte[] ret = b.toByteArray();
        g.close();
        b.close();
        return ret;
    }

    public byte[] uncompress(byte[] bytes) {
        ByteArrayInputStream b = new ByteArrayInputStream(bytes);
        GZIPInputStream g = new GZIPInputStream(b);
        ByteArrayOutputStream acc = new ByteArrayOutputStream();
        byte[] tmp = new byte[1024];
        int len = 0;
        do {
            if ((len = g.read(tmp)) <= 0) continue;
            acc.write(tmp, 0, len);
        } while (len > 0);
        byte[] ret = acc.toByteArray();
        acc.close();
        g.close();
        b.close();
        return ret;
    }

    public byte[] mayUncompress(byte[] maybeCompressed) {
        return this.isCompressed(maybeCompressed) ? this.uncompress(maybeCompressed) : maybeCompressed;
    }

    public boolean isAccepted(HttpRequest request) {
        String acceptEncoding;
        return Config$.MODULE$.xitrum().response().autoGzip() ? (acceptEncoding = HttpHeaders.getHeader((HttpMessage)request, (String)"Accept-Encoding")) != null && acceptEncoding.contains("gzip") : false;
    }

    public byte[] tryCompressBigTextualResponse(HttpRequest request, FullHttpResponse response, boolean needBytes) {
        CompositeByteBuf cb = (CompositeByteBuf)response.content();
        if (this.isAccepted(request) && !response.headers().contains("Content-Encoding") && Mime$.MODULE$.isTextual(HttpHeaders.getHeader((HttpMessage)response, (String)"Content-Type")) && cb.readableBytes() >= Config$.MODULE$.BIG_TEXTUAL_RESPONSE_SIZE_IN_KB() * 1024) {
            byte[] bytes = ByteBufUtil$.MODULE$.toBytes((ByteBuf)cb);
            byte[] gzippedBytes = this.compress(bytes);
            HttpHeaders.setContentLength((HttpMessage)response, (long)gzippedBytes.length);
            HttpHeaders.setHeader((HttpMessage)response, (String)"Content-Encoding", (Object)"gzip");
            cb.removeComponents(0, cb.numComponents());
            cb.clear();
            ByteBufUtil$.MODULE$.writeComposite((ByteBuf)cb, Unpooled.wrappedBuffer((byte[])gzippedBytes));
            return (byte[])(needBytes ? gzippedBytes : null);
        }
        return needBytes ? ByteBufUtil$.MODULE$.toBytes((ByteBuf)cb) : null;
    }

    private Gzip$() {
        MODULE$ = this;
        this.GZIP_SIGNATURE_BYTE1 = (byte)35615;
        this.GZIP_SIGNATURE_BYTE2 = (byte)139;
    }
}

