/*
 * Decompiled with CFR 0.152.
 */
package xitrum;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import xitrum.Config$;
import xitrum.PortConfig;
import xitrum.handler.DefaultHttpChannelInitializer;
import xitrum.handler.FlashSocketPolicyServer$;
import xitrum.handler.NetOption$;
import xitrum.handler.SslChannelInitializer;
import xitrum.handler.inbound.Dispatcher$;
import xitrum.metrics.MetricsManager$;
import xitrum.package$;
import xitrum.sockjs.SockJsAction$;

public final class Server$ {
    public static final Server$ MODULE$;

    static {
        new Server$();
    }

    public void start() {
        this.addConfigDirectoryToClasspath();
        this.start(new DefaultHttpChannelInitializer());
    }

    public void start(ChannelInitializer<SocketChannel> httpChannelInitializer) {
        PortConfig portConfig;
        Config$.MODULE$.xitrum().loadExternalEngines();
        SockJsAction$.MODULE$.entropy();
        if (Config$.MODULE$.xitrum().metrics().isDefined()) {
            MetricsManager$.MODULE$.start();
        }
        Config$.MODULE$.routes().logAll();
        if (!Config$.MODULE$.productionMode()) {
            ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.ADVANCED);
        }
        if ((portConfig = Config$.MODULE$.xitrum().port()).http().isDefined()) {
            this.doStart(false, httpChannelInitializer);
        }
        if (portConfig.https().isDefined()) {
            this.doStart(true, httpChannelInitializer);
        }
        if (portConfig.flashSocketPolicy().isDefined()) {
            Option<Object> option = portConfig.flashSocketPolicy();
            Option<Object> option2 = portConfig.http();
            if (!(option != null ? !option.equals(option2) : option2 != null)) {
                package$.MODULE$.Log().info((Function0)new Serializable(){

                    public final String apply() {
                        return "Flash socket policy file will be served by the HTTP server";
                    }
                });
            } else {
                FlashSocketPolicyServer$.MODULE$.start();
            }
        }
        if (Config$.MODULE$.productionMode()) {
            package$.MODULE$.Log().info((Function0)new Serializable(){

                public final String apply() {
                    return "Xitrum started in production mode";
                }
            });
        } else {
            package$.MODULE$.Log().info((Function0)new Serializable(){

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Xitrum started in development mode; routes and classes in directory ", " will be reloaded"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Dispatcher$.MODULE$.DEVELOPMENT_MODE_CLASSES_DIR()}));
                }
            });
        }
        Config$.MODULE$.warnOnDefaultSecureKey();
    }

    private void addConfigDirectoryToClasspath() {
        String configDirPath = new StringBuilder().append((Object)package$.MODULE$.root()).append((Object)File.separator).append((Object)"config").toString();
        File configDir = new File(configDirPath);
        if (configDir.exists()) {
            ClassLoader cl = this.getClass().getClassLoader();
            URL appUrl = cl.getResource("application.conf");
            if (appUrl == null) {
                this.findURLClassLoader(cl).foreach((Function1)new Serializable(configDir){
                    private final File configDir$1;

                    public final Object apply(URLClassLoader urlCl) {
                        URL configDirUrl = this.configDir$1.toURI().toURL();
                        Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        method.setAccessible(true);
                        return method.invoke((Object)urlCl, configDirUrl);
                    }
                    {
                        this.configDir$1 = configDir$1;
                    }
                });
                return;
            }
            return;
        }
    }

    private Option<URLClassLoader> findURLClassLoader(ClassLoader cl) {
        while (true) {
            ClassLoader parent;
            block5: {
                Some some;
                block4: {
                    block3: {
                        if (!(cl instanceof URLClassLoader)) break block3;
                        some = new Some((Object)((URLClassLoader)cl));
                        break block4;
                    }
                    parent = cl.getParent();
                    if (parent != null) break block5;
                    some = None$.MODULE$;
                }
                return some;
            }
            cl = parent;
        }
    }

    private void doStart(boolean https, ChannelInitializer<SocketChannel> nonSslChannelInitializer) {
        Tuple2 tuple2;
        block2: {
            Option<String> option;
            block5: {
                block4: {
                    int port;
                    String service;
                    block3: {
                        Tuple2 tuple22;
                        SslChannelInitializer channelInitializer = https ? new SslChannelInitializer(nonSslChannelInitializer) : nonSslChannelInitializer;
                        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
                        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
                        ServerBootstrap bootstrap = new ServerBootstrap();
                        ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)channelInitializer);
                        PortConfig portConfig = Config$.MODULE$.xitrum().port();
                        Tuple2 tuple23 = tuple2 = https ? new Tuple2((Object)"HTTPS", portConfig.https().get()) : new Tuple2((Object)"HTTP", portConfig.http().get());
                        if (tuple2 == null) break block2;
                        String service2 = (String)tuple2._1();
                        int port2 = tuple2._2$mcI$sp();
                        Tuple2 tuple24 = tuple22 = new Tuple2((Object)service2, (Object)BoxesRunTime.boxToInteger((int)port2));
                        service = (String)tuple24._1();
                        port = tuple24._2$mcI$sp();
                        NetOption$.MODULE$.setOptions(bootstrap);
                        NetOption$.MODULE$.bind(service, bootstrap, port, bossGroup, workerGroup);
                        option = Config$.MODULE$.xitrum().interface();
                        if (!None$.MODULE$.equals(option)) break block3;
                        package$.MODULE$.Log().info((Function0)new Serializable(service, port){
                            private final String service$1;
                            private final int port$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " server started on port ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.service$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                            }
                            {
                                this.service$1 = service$1;
                                this.port$1 = port$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    if (!(option instanceof Some)) break block5;
                    Some some = (Some)option;
                    String hostnameOrIp = (String)some.x();
                    package$.MODULE$.Log().info((Function0)new Serializable(service, port, hostnameOrIp){
                        private final String service$1;
                        private final int port$1;
                        private final String hostnameOrIp$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " server started on ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.service$1, this.hostnameOrIp$1, BoxesRunTime.boxToInteger((int)this.port$1)}));
                        }
                        {
                            this.service$1 = service$1;
                            this.port$1 = port$1;
                            this.hostnameOrIp$1 = hostnameOrIp$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)tuple2);
    }

    private Server$() {
        MODULE$ = this;
    }
}

