/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.router.Router;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLException;
import sinetja.Action;
import sinetja.DefaultErrorHandler;
import sinetja.DefaultInstantiator;
import sinetja.DefaultNotFoundHandler;
import sinetja.ErrorHandler;
import sinetja.Instantiator;
import sinetja.Log;
import sinetja.PipelineInitializer;

public class Server
extends Router<Action> {
    private static final int MAX_CONTENT_LENGTH = 0x100000;
    private String host;
    private int port;
    private SslContext sslContext = null;
    private int maxContentLength = 0x100000;
    private Charset charset = CharsetUtil.UTF_8;
    private CorsConfig cors;
    private Instantiator instantiator;
    private Object before;
    private Object after;
    private Object error;
    private List<EventLoopGroup> eventLoopGroups = new ArrayList<EventLoopGroup>();

    public Server(int n) {
        this("0.0.0.0", n);
    }

    public Server(String string, int n) {
        this.host = string;
        this.port = n;
        this.instantiator(new DefaultInstantiator());
        this.notFound(new DefaultNotFoundHandler());
        this.error(new DefaultErrorHandler());
    }

    public SslContext sslContext() {
        return this.sslContext;
    }

    public Server sslContext(SslContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Server jdkSsl() throws SSLException, CertificateException {
        SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
        this.sslContext = SslContextBuilder.forServer((File)selfSignedCertificate.certificate(), (File)selfSignedCertificate.privateKey()).sslProvider(SslProvider.JDK).build();
        return this;
    }

    public Server jdkSsl(String string, String string2) throws SSLException {
        this.sslContext = SslContextBuilder.forServer((File)new File(string), (File)new File(string2)).sslProvider(SslProvider.JDK).build();
        return this;
    }

    public Server jdkSsl(String string, String string2, String string3) throws SSLException {
        this.sslContext = SslContextBuilder.forServer((File)new File(string), (File)new File(string2), (String)string3).sslProvider(SslProvider.JDK).build();
        return this;
    }

    public Server openSsl() throws SSLException, CertificateException {
        SelfSignedCertificate selfSignedCertificate = new SelfSignedCertificate();
        this.sslContext = SslContextBuilder.forServer((File)selfSignedCertificate.certificate(), (File)selfSignedCertificate.privateKey()).sslProvider(SslProvider.OPENSSL).build();
        return this;
    }

    public Server openSsl(String string, String string2) throws SSLException {
        this.sslContext = SslContextBuilder.forServer((File)new File(string), (File)new File(string2)).sslProvider(SslProvider.OPENSSL).build();
        return this;
    }

    public Server openSsl(String string, String string2, String string3) throws SSLException {
        this.sslContext = SslContextBuilder.forServer((File)new File(string), (File)new File(string2), (String)string3).sslProvider(SslProvider.OPENSSL).build();
        return this;
    }

    public int maxContentLength() {
        return this.maxContentLength;
    }

    public Server maxContentLength(int n) {
        this.maxContentLength = n;
        return this;
    }

    public Charset charset() {
        return this.charset;
    }

    public Server charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public CorsConfig cors() {
        return this.cors;
    }

    public Server cors(CorsConfig corsConfig) {
        this.cors = corsConfig;
        return this;
    }

    public Instantiator instantiator() {
        return this.instantiator;
    }

    public Server instantiator(Instantiator instantiator) {
        this.instantiator = instantiator;
        return this;
    }

    public Object before() {
        return this.before;
    }

    public Server before(Action action) {
        this.before = action;
        return this;
    }

    public Server before(Class<? extends Action> clazz) {
        this.before = clazz;
        return this;
    }

    public Object after() {
        return this.after;
    }

    public Server after(Action action) {
        this.after = action;
        return this;
    }

    public Server after(Class<? extends Action> clazz) {
        this.after = clazz;
        return this;
    }

    public Object error() {
        return this.error;
    }

    public Server error(ErrorHandler errorHandler) {
        this.error = errorHandler;
        return this;
    }

    public Server error(Class<? extends ErrorHandler> clazz) {
        this.error = clazz;
        return this;
    }

    public void start() {
        Log.info(this.serverName() + " starting...");
        this.bootstrap().bind(this.host, this.port).awaitUninterruptibly();
        Log.info(this.serverName() + " started");
    }

    public void stop() {
        Log.info(this.serverName() + " gracefully stopping...");
        for (EventLoopGroup eventLoopGroup : this.eventLoopGroups) {
            eventLoopGroup.shutdownGracefully().awaitUninterruptibly();
        }
        Log.info(this.serverName() + " gracefully stopped");
    }

    public void stopAtShutdown() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Server.this.stop();
            }
        });
    }

    private String serverName() {
        return this.sslContext == null ? "http://" + this.host + ":" + this.port + "/" : "https://" + this.host + ":" + this.port + "/";
    }

    private ServerBootstrap bootstrap() {
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup nioEventLoopGroup2 = new NioEventLoopGroup();
        this.eventLoopGroups.add((EventLoopGroup)nioEventLoopGroup);
        this.eventLoopGroups.add((EventLoopGroup)nioEventLoopGroup2);
        return ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)nioEventLoopGroup, (EventLoopGroup)nioEventLoopGroup2).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new PipelineInitializer(this));
    }
}

