/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.router.RouteResult;
import io.netty.util.concurrent.GenericFutureListener;
import sinetja.Action;
import sinetja.DefaultErrorHandler;
import sinetja.ErrorHandler;
import sinetja.Log;
import sinetja.NoRealPipelining;
import sinetja.Request;
import sinetja.Response;
import sinetja.Server;

@ChannelHandler.Sharable
class RouterHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Server server;

    RouterHandler(Server server) {
        this.server = server;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest fullHttpRequest) throws Exception {
        String string;
        long l = System.nanoTime();
        Channel channel = channelHandlerContext.channel();
        RouteResult routeResult = this.server.route(fullHttpRequest.method(), fullHttpRequest.uri());
        final Request request = new Request(this.server, channel, fullHttpRequest, routeResult);
        final Response response = new Response(this.server, channel, request, routeResult);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (request.refCnt() > 0) {
                    request.release(request.refCnt());
                }
                if (response.refCnt() > 0) {
                    response.release(response.refCnt());
                }
            }
        });
        try {
            Action action = (Action)this.server.instantiator().instantiate(this.server.before());
            if (action != null) {
                action.run(request, response);
            }
            if (!response.doneResponding()) {
                Action action2 = (Action)this.server.instantiator().instantiate(routeResult.target());
                action2.run(request, response);
                if (!response.doneResponding()) {
                    NoRealPipelining.pauseReading(channel);
                }
            }
        }
        catch (Exception exception) {
            try {
                ErrorHandler errorHandler = (ErrorHandler)this.server.instantiator().instantiate(this.server.error());
                errorHandler.run(request, response, exception);
            }
            catch (Exception exception2) {
                new DefaultErrorHandler().run(request, response, exception2);
            }
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        String string2 = string = response.doneResponding() ? response.getStatus() : "async";
        if (l3 >= 1000000L) {
            Log.info("[{}] {} {} - {} {} [ms]", request.remoteIp(), request.getMethod(), request.getUri(), string, l3 / 1000000L);
        } else if (l3 >= 1000L) {
            Log.info("[{}] {} {} - {} {} [us]", request.remoteIp(), request.getMethod(), request.getUri(), string, l3 / 1000L);
        } else {
            Log.info("[{}] {} {} - {} {} [ns]", request.remoteIp(), request.getMethod(), request.getUri(), string, l3);
        }
    }
}

