/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.router.RouteResult;
import java.io.File;
import java.nio.charset.Charset;
import sinetja.Action;
import sinetja.NoRealPipelining;
import sinetja.NotModified;
import sinetja.Request;
import sinetja.Server;

public class Response
implements FullHttpResponse {
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    private final Server server;
    private final Channel channel;
    private final Request request;
    private final RouteResult routeResult;
    private final FullHttpResponse response;
    private boolean nonChunkedResponseOrFirstChunkSent = false;
    private boolean doneResponding = false;

    public Response(Server server, Channel channel, Request request, RouteResult routeResult) {
        this.server = server;
        this.channel = channel;
        this.request = request;
        this.routeResult = routeResult;
        this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, routeResult == null ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.OK);
    }

    public boolean doneResponding() {
        return this.doneResponding;
    }

    private void throwDoubleResponseError() throws IllegalStateException {
        throw new IllegalStateException("Double response error. See stack trace to know where to fix the error.");
    }

    private void throwDoubleResponseError(Object object) throws IllegalStateException {
        throw new IllegalStateException("Double response error. See stack trace to know where to fix the error. You're trying to respond: " + object + "\n");
    }

    private void respondHeadersOnlyForFirstChunk() throws Exception {
        if (this.doneResponding) {
            this.throwDoubleResponseError();
        }
        if (this.nonChunkedResponseOrFirstChunkSent) {
            return;
        }
        if (!this.response.headers().contains("Content-Type")) {
            this.response.headers().set("Content-Type", (Object)"application/octet-stream");
        }
        this.response.headers().remove("Content-Length");
        this.setNoClientCache();
        this.respond();
    }

    public void setClientCacheAggressively() {
        NotModified.setClientCacheAggressively(this.response.headers());
    }

    public void setNoClientCache() {
        NotModified.setNoClientCache(this.response.headers());
    }

    public ChannelFuture respond() throws Exception {
        Action action;
        if (this.nonChunkedResponseOrFirstChunkSent) {
            this.throwDoubleResponseError();
        }
        if ((action = (Action)this.server.instantiator().instantiate(this.server.after())) != null) {
            action.run(this.request, this);
        }
        ChannelFuture channelFuture = this.channel.writeAndFlush((Object)this.response);
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.response)) {
            NoRealPipelining.if_keepAliveRequest_then_resumeReading_else_closeOnComplete((HttpRequest)this.request, this.channel, channelFuture);
        }
        this.nonChunkedResponseOrFirstChunkSent = true;
        if (!HttpUtil.isTransferEncodingChunked((HttpMessage)this.response)) {
            this.doneResponding = true;
        }
        return channelFuture;
    }

    public ChannelFuture respondText(Object object) throws Exception {
        return this.respondText(object, null);
    }

    public ChannelFuture respondText(Object object, String string) throws Exception {
        Object object2;
        if (this.doneResponding) {
            this.throwDoubleResponseError(object);
        }
        String string2 = object.toString();
        if (!this.nonChunkedResponseOrFirstChunkSent && !this.response.headers().contains("Content-Type")) {
            if (string != null) {
                object2 = string.toLowerCase().contains("charset") ? string : string + "; charset=" + this.server.charset();
                this.response.headers().set("Content-Type", object2);
            } else {
                this.response.headers().set("Content-Type", (Object)("text/plain; charset=" + this.server.charset()));
            }
        }
        object2 = Unpooled.copiedBuffer((CharSequence)string2, (Charset)this.server.charset());
        if (HttpHeaders.isTransferEncodingChunked((HttpMessage)this.response)) {
            this.respondHeadersOnlyForFirstChunk();
            return this.channel.writeAndFlush((Object)new DefaultHttpContent(object2));
        }
        this.response.headers().set("Content-Length", (Object)object2.readableBytes());
        this.response.content().writeBytes(object2);
        return this.respond();
    }

    public ChannelFuture respondXml(Object object) throws Exception {
        return this.respondText(object, "application/xml");
    }

    public ChannelFuture respondHtml(Object object) throws Exception {
        return this.respondText(object, "text/html");
    }

    public ChannelFuture respondJs(Object object) throws Exception {
        return this.respondText(object, "application/javascript");
    }

    public ChannelFuture respondJsonText(Object object) throws Exception {
        return this.respondText(object, "application/json");
    }

    public ChannelFuture respondJson(Object object) throws Exception {
        String string = jsonObjectMapper.writeValueAsString(object);
        return this.respondText(string, "application/json");
    }

    public ChannelFuture respondJsonPText(Object object, String string) throws Exception {
        return this.respondJs(string + "(" + object + ");\r\n");
    }

    public ChannelFuture respondJsonP(Object object, String string) throws Exception {
        String string2 = jsonObjectMapper.writeValueAsString(object);
        String string3 = string + "(" + string2 + ");\r\n";
        return this.respondJs(string3);
    }

    public ChannelFuture respondBinary(byte[] byArray) throws Exception {
        return this.respondBinary(Unpooled.wrappedBuffer((byte[])byArray));
    }

    public ChannelFuture respondBinary(ByteBuf byteBuf) throws Exception {
        if (HttpUtil.isTransferEncodingChunked((HttpMessage)this.response)) {
            this.respondHeadersOnlyForFirstChunk();
            return this.channel.writeAndFlush((Object)new DefaultHttpContent(byteBuf));
        }
        if (!this.response.headers().contains("Content-Type")) {
            this.response.headers().set("Content-Type", (Object)"application/octet-stream");
        }
        this.response.headers().set("Content-Length", (Object)byteBuf.readableBytes());
        this.response.content().writeBytes(byteBuf);
        return this.respond();
    }

    public ChannelFuture respondFile(String string) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public ChannelFuture respondFile(File file) {
        throw new UnsupportedOperationException("To be implemented");
    }

    public String renderEventSource(Object object) {
        return this.renderEventSource(object, "message");
    }

    public String renderEventSource(Object object, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!string.equals("message")) {
            stringBuilder.append("event: ");
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        String[] stringArray = object.toString().split("\n");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i < n - 1) {
                stringBuilder.append("data: ");
                stringBuilder.append(stringArray[i]);
                stringBuilder.append("\n");
                continue;
            }
            stringBuilder.append("data: ");
            stringBuilder.append(stringArray[i]);
        }
        stringBuilder.append("\r\n\r\n");
        return stringBuilder.toString();
    }

    public ChannelFuture respondEventSource(Object object) throws Exception {
        return this.respondEventSource(object, "message");
    }

    public ChannelFuture respondEventSource(Object object, String string) throws Exception {
        if (!this.nonChunkedResponseOrFirstChunkSent) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)this.response, (boolean)true);
            this.response.headers().set("Content-Type", (Object)"text/event-stream; charset=UTF-8");
            return this.respondText("\r\n");
        }
        return this.respondText(this.renderEventSource(object, string));
    }

    public HttpResponseStatus getStatus() {
        return this.response.getStatus();
    }

    public HttpResponseStatus status() {
        return this.response.status();
    }

    public HttpVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public HttpVersion protocolVersion() {
        return this.response.protocolVersion();
    }

    public HttpHeaders headers() {
        return this.response.headers();
    }

    public DecoderResult getDecoderResult() {
        return this.response.getDecoderResult();
    }

    public DecoderResult decoderResult() {
        return this.response.decoderResult();
    }

    public void setDecoderResult(DecoderResult decoderResult) {
        this.response.setDecoderResult(decoderResult);
    }

    public HttpHeaders trailingHeaders() {
        return this.response.trailingHeaders();
    }

    public FullHttpResponse retainedDuplicate() {
        return this.response.retainedDuplicate();
    }

    public FullHttpResponse replace(ByteBuf byteBuf) {
        return this.response.replace(byteBuf);
    }

    public ByteBuf content() {
        return this.response.content();
    }

    public int refCnt() {
        return this.response.refCnt();
    }

    public boolean release() {
        return this.response.release();
    }

    public boolean release(int n) {
        return this.response.release(n);
    }

    public FullHttpResponse copy() {
        return this.response.copy();
    }

    public FullHttpResponse duplicate() {
        return this.response.duplicate();
    }

    public FullHttpResponse retain() {
        return this.response.retain();
    }

    public FullHttpResponse touch() {
        return this.response.touch();
    }

    public FullHttpResponse touch(Object object) {
        return this.response.touch(object);
    }

    public FullHttpResponse retain(int n) {
        return this.response.retain(n);
    }

    public FullHttpResponse setProtocolVersion(HttpVersion httpVersion) {
        return this.response.setProtocolVersion(httpVersion);
    }

    public FullHttpResponse setStatus(HttpResponseStatus httpResponseStatus) {
        return this.response.setStatus(httpResponseStatus);
    }

    public String toString() {
        return this.response.toString();
    }
}

