/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.BadClientSilencer;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.ssl.SslContext;
import sinetja.Log;
import sinetja.RouterHandler;
import sinetja.Server;

class PipelineInitializer
extends ChannelInitializer<SocketChannel> {
    private final Server server;
    private final RouterHandler routerHandler;
    private final BadClientSilencer badClientSilencer;

    public PipelineInitializer(Server server) {
        this.server = server;
        this.routerHandler = new RouterHandler(server);
        this.badClientSilencer = new BadClientSilencer(){

            protected void onUnknownMessage(Object object) {
                if (object != LastHttpContent.EMPTY_LAST_CONTENT) {
                    Log.trace("Unknown msg: " + object);
                }
            }

            protected void onBadClient(Throwable throwable) {
                Log.trace("Caught exception (maybe client is bad)", throwable);
            }

            protected void onBadServer(Throwable throwable) {
                Log.error("Caught exception (maybe server is bad)", throwable);
            }
        };
    }

    public void initChannel(SocketChannel socketChannel) {
        ChannelPipeline channelPipeline = socketChannel.pipeline();
        SslContext sslContext = this.server.sslContext();
        if (sslContext != null) {
            channelPipeline.addLast(new ChannelHandler[]{sslContext.newHandler(socketChannel.alloc())});
        }
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.server.maxContentLength())});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        if (this.server.cors() != null) {
            channelPipeline.addLast(new ChannelHandler[]{new CorsHandler(this.server.cors())});
        }
        channelPipeline.addLast(new ChannelHandler[]{this.routerHandler});
        channelPipeline.addLast(new ChannelHandler[]{this.badClientSilencer});
    }
}

