/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.handler.codec.http.HttpHeaders;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;

public class NotModified {
    private static final int SECS_IN_A_YEAR = 31536000;
    private static final SimpleDateFormat RFC_2822 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public static String formatRfc2822(Long l) {
        return RFC_2822.format(l);
    }

    public static void setClientCacheAggressively(HttpHeaders httpHeaders) {
        if (!httpHeaders.contains("Cache-Control")) {
            httpHeaders.set("Cache-Control", (Object)"public, max-age=31536000");
        }
        if (!httpHeaders.contains("Access-Control-Max-Age")) {
            httpHeaders.set("Access-Control-Max-Age", (Object)31536000);
        }
        if (!httpHeaders.contains("Expires")) {
            httpHeaders.set("Expires", (Object)NotModified.formatRfc2822(System.currentTimeMillis() + 31536000000L));
        }
    }

    public static void setNoClientCache(HttpHeaders httpHeaders) {
        httpHeaders.remove("Expires");
        httpHeaders.remove("Last-Modified");
        httpHeaders.set("Cache-Control", (Object)"no-store, no-cache, must-revalidate, max-age=0");
    }

    static {
        RFC_2822.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

