/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.router.MethodRouter;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import sinetja.ErrorHandler;
import sinetja.Log;
import sinetja.PipelineInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
extends MethodRouter<Object, Server> {
    public static final int MAX_CONTENT_LENGTH = 0x100000;
    private boolean openSsl = false;
    private int maxContentLength = 0x100000;
    private Charset charset = CharsetUtil.UTF_8;
    private Object errorHandler;
    protected final PipelineInitializer pipelineInitializer = new PipelineInitializer(this);

    protected Server getThis() {
        return this;
    }

    public boolean openSsl() {
        return this.openSsl;
    }

    public Server openSsl(boolean bl) {
        this.openSsl = bl;
        return this.getThis();
    }

    public int maxContentLength() {
        return this.maxContentLength;
    }

    public Server maxContentLength(int n) {
        this.maxContentLength = n;
        return this.getThis();
    }

    public Charset charset() {
        return this.charset;
    }

    public Server charset(Charset charset) {
        this.charset = charset;
        return this.getThis();
    }

    public Object errorHandler() {
        return this.errorHandler;
    }

    public Server ERROR(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
        return this.getThis();
    }

    public Server ERROR(Class<? extends ErrorHandler> clazz) {
        this.errorHandler = clazz;
        return this.getThis();
    }

    public void start(int n) {
        NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup nioEventLoopGroup2 = new NioEventLoopGroup();
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.group((EventLoopGroup)nioEventLoopGroup, (EventLoopGroup)nioEventLoopGroup2).childOption(ChannelOption.TCP_NODELAY, (Object)Boolean.TRUE).childOption(ChannelOption.SO_KEEPALIVE, (Object)Boolean.TRUE).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)this.pipelineInitializer);
            Channel channel = serverBootstrap.bind(n).sync().channel();
            Log.info("HTTP server started: http://127.0.0.1:" + n + '/');
            channel.closeFuture().sync();
        }
        catch (InterruptedException interruptedException) {
            nioEventLoopGroup.shutdownGracefully();
            nioEventLoopGroup2.shutdownGracefully();
        }
    }

    public void start(int n, String string, String string2) {
    }
}

