/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.router.DualAbstractHandler;
import io.netty.handler.codec.http.router.MethodRouter;
import io.netty.handler.codec.http.router.Routed;
import io.netty.util.concurrent.GenericFutureListener;
import sinetja.Action;
import sinetja.ErrorHandler;
import sinetja.Log;
import sinetja.MissingParam;
import sinetja.Request;
import sinetja.Response;
import sinetja.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterHandler
extends DualAbstractHandler<Server> {
    private final Server server;

    public RouterHandler(Server server) {
        super((MethodRouter)server);
        this.server = server;
    }

    protected void routed(ChannelHandlerContext channelHandlerContext, Routed routed, Object object) throws Exception {
        long l = System.nanoTime();
        Action action = (Action)object;
        Channel channel = channelHandlerContext.channel();
        final Request request = new Request(this.server, channel, routed);
        final Response response = new Response(this.server, channel, routed);
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (request.refCnt() > 0) {
                    request.release(request.refCnt());
                }
                if (response.refCnt() > 0) {
                    response.release(response.refCnt());
                }
            }
        });
        try {
            action.run(request, response);
        }
        catch (Exception exception) {
            ErrorHandler errorHandler = null;
            Object object2 = this.server.errorHandler();
            if (object2 instanceof Class) {
                Class clazz = (Class)object2;
                errorHandler = (ErrorHandler)clazz.newInstance();
            } else {
                errorHandler = (ErrorHandler)object2;
            }
            if (errorHandler == null) {
                this.handleError(request, response, exception);
            }
            try {
                response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
                errorHandler.run(request, response, exception);
            }
            catch (Exception exception2) {
                this.handleError(request, response, exception2);
            }
        }
        long l2 = System.nanoTime();
        long l3 = l2 - l;
        if (l3 >= 1000000L) {
            Log.info("[{}] {} {} - {} [ms]", request.remoteIp(), request.getMethod(), request.getUri(), l3 / 1000000L);
        } else if (l3 >= 1000L) {
            Log.info("[{}] {} {} - {} [us]", request.remoteIp(), request.getMethod(), request.getUri(), l3 / 1000L);
        } else {
            Log.info("[{}] {} {} - {} [ns]", request.remoteIp(), request.getMethod(), request.getUri(), l3);
        }
    }

    protected void handleError(Request request, Response response, Exception exception) {
        if (exception instanceof MissingParam) {
            response.setStatus(HttpResponseStatus.BAD_REQUEST);
            response.respondMissingParam((MissingParam)exception);
        } else {
            Log.error("Server error: {}\nWhen processing request: {}", (Object)exception, (Object)request);
            response.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            response.respondServerError(exception);
        }
    }
}

