/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.router.KeepAliveWrite;
import io.netty.handler.codec.http.router.Routed;
import sinetja.MissingParam;
import sinetja.Server;

public class Response
implements FullHttpResponse {
    protected static final ByteBuf INTERNAL_SERVER_ERROR = Unpooled.copiedBuffer((byte[])"Internal Server Error".getBytes());
    private final Server server;
    private final Channel channel;
    private final Routed routed;
    private final FullHttpResponse response;

    public Response(Server server, Channel channel, Routed routed) {
        this.server = server;
        this.channel = channel;
        this.routed = routed;
        this.response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, routed.notFound() ? HttpResponseStatus.NOT_FOUND : HttpResponseStatus.OK);
    }

    protected void respondMissingParam(MissingParam missingParam) {
        this.respondText("Missing param: " + missingParam.param());
    }

    protected void respondServerError(Exception exception) {
        this.respondText(INTERNAL_SERVER_ERROR);
    }

    protected ChannelFuture respondText(Object object) {
        byte[] byArray = object.toString().getBytes(this.server.charset());
        ByteBuf byteBuf = Unpooled.copiedBuffer((byte[])byArray);
        ChannelFuture channelFuture = this.respondText(byteBuf);
        byteBuf.release();
        return channelFuture;
    }

    protected ChannelFuture respondText(ByteBuf byteBuf) {
        HttpHeaders httpHeaders = this.response.headers();
        if (httpHeaders.contains("Content-Type")) {
            httpHeaders.set("Content-Type", (Object)"text/plain");
        }
        this.response.content().writeBytes(byteBuf);
        httpHeaders.set("Content-Length", (Object)this.response.content().readableBytes());
        return KeepAliveWrite.flush((Channel)this.channel, (HttpRequest)this.routed.request(), (HttpResponse)this.response);
    }

    public HttpResponseStatus getStatus() {
        return this.response.getStatus();
    }

    public HttpVersion getProtocolVersion() {
        return this.response.getProtocolVersion();
    }

    public HttpHeaders headers() {
        return this.response.headers();
    }

    public DecoderResult getDecoderResult() {
        return this.response.getDecoderResult();
    }

    public void setDecoderResult(DecoderResult decoderResult) {
        this.response.setDecoderResult(decoderResult);
    }

    public HttpHeaders trailingHeaders() {
        return this.response.trailingHeaders();
    }

    public HttpContent duplicate() {
        return this.response.duplicate();
    }

    public ByteBuf content() {
        return this.response.content();
    }

    public int refCnt() {
        return this.response.refCnt();
    }

    public boolean release() {
        return this.response.release();
    }

    public boolean release(int n) {
        return this.response.release(n);
    }

    public FullHttpResponse copy() {
        return this.response.copy();
    }

    public FullHttpResponse retain() {
        return this.response.retain();
    }

    public FullHttpResponse retain(int n) {
        return this.response.retain(n);
    }

    public FullHttpResponse setProtocolVersion(HttpVersion httpVersion) {
        return this.response.setProtocolVersion(httpVersion);
    }

    public FullHttpResponse setStatus(HttpResponseStatus httpResponseStatus) {
        return this.response.setStatus(httpResponseStatus);
    }

    public String toString() {
        return this.response.toString();
    }
}

