/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.router.Routed;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import sinetja.MissingParam;
import sinetja.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Request
implements FullHttpRequest {
    private final Server server;
    private final Channel channel;
    private final Routed routed;
    private final String clientIp;
    private final String remoteIp;
    private final FullHttpRequest request;
    private final Map<String, List<String>> bodyParams;

    public Request(Server server, Channel channel, Routed routed) {
        this.server = server;
        this.channel = channel;
        this.routed = routed;
        this.request = (FullHttpRequest)routed.request();
        this.clientIp = this.getClientIpFromChannel();
        this.remoteIp = this.getRemoteIpFromClientIpOrReverseProxy();
        String string = this.request.headers().get("Content-Type");
        if ("application/x-www-form-urlencoded".equals(string)) {
            String string2 = this.request.content().toString(server.charset());
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder("?" + string2);
            this.bodyParams = queryStringDecoder.parameters();
        } else {
            this.bodyParams = Collections.emptyMap();
        }
    }

    public Server server() {
        return this.server;
    }

    public Channel channel() {
        return this.channel;
    }

    public String clientIp() {
        return this.clientIp;
    }

    public String remoteIp() {
        return this.remoteIp;
    }

    private String getClientIpFromChannel() {
        SocketAddress socketAddress = this.channel.remoteAddress();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        InetAddress inetAddress = inetSocketAddress.getAddress();
        return inetAddress.getHostAddress();
    }

    private String getRemoteIpFromClientIpOrReverseProxy() {
        return this.clientIp;
    }

    public String path() {
        return this.routed.path();
    }

    public Map<String, String> pathParams() {
        return this.routed.pathParams();
    }

    public Map<String, List<String>> queryParams() {
        return this.routed.queryParams();
    }

    public Map<String, List<String>> bodyParams() {
        return this.bodyParams;
    }

    public String param(String string) throws MissingParam {
        String string2 = (String)this.routed.pathParams().get(string);
        if (string2 != null) {
            return string2;
        }
        if (this.bodyParams != null && this.bodyParams.containsKey(string)) {
            return this.bodyParams.get(string).get(0);
        }
        string2 = this.routed.queryParam(string);
        if (string2 != null) {
            return string2;
        }
        throw new MissingParam(string);
    }

    public String paramo(String string) {
        String string2 = (String)this.routed.pathParams().get(string);
        if (string2 != null) {
            return string2;
        }
        if (this.bodyParams != null && this.bodyParams.containsKey(string)) {
            return this.bodyParams.get(string).get(0);
        }
        string2 = this.routed.queryParam(string);
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    public List<String> params(String string) {
        List list = this.routed.params(string);
        if (this.bodyParams.containsKey(string)) {
            list.addAll((Collection)this.bodyParams.get(string));
        }
        return list;
    }

    public HttpMethod getMethod() {
        return this.request.getMethod();
    }

    public String getUri() {
        return this.request.getUri();
    }

    public HttpVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public HttpHeaders headers() {
        return this.request.headers();
    }

    public DecoderResult getDecoderResult() {
        return this.request.getDecoderResult();
    }

    public void setDecoderResult(DecoderResult decoderResult) {
        this.request.setDecoderResult(decoderResult);
    }

    public HttpHeaders trailingHeaders() {
        return this.request.trailingHeaders();
    }

    public HttpContent duplicate() {
        return this.request.duplicate();
    }

    public ByteBuf content() {
        return this.request.content();
    }

    public int refCnt() {
        return this.refCnt();
    }

    public boolean release() {
        return this.request.release();
    }

    public boolean release(int n) {
        return this.request.release(n);
    }

    public FullHttpRequest copy() {
        return this.request.copy();
    }

    public FullHttpRequest retain() {
        return this.request.retain();
    }

    public FullHttpRequest retain(int n) {
        return this.request.retain(n);
    }

    public FullHttpRequest setMethod(HttpMethod httpMethod) {
        return this.request.setMethod(httpMethod);
    }

    public FullHttpRequest setProtocolVersion(HttpVersion httpVersion) {
        return this.request.setProtocolVersion(httpVersion);
    }

    public FullHttpRequest setUri(String string) {
        return this.request.setUri(string);
    }

    public String toString() {
        return this.request.toString();
    }
}

