/*
 * Decompiled with CFR 0.152.
 */
package sinetja;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.router.BadClientSilencer;
import sinetja.RouterHandler;
import sinetja.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PipelineInitializer
extends ChannelInitializer<SocketChannel> {
    private final Server server;
    private final RouterHandler routerHandler;
    private final BadClientSilencer badClientSilencer = new BadClientSilencer();

    public PipelineInitializer(Server server) {
        this.server = server;
        this.routerHandler = new RouterHandler(server);
    }

    public void initChannel(SocketChannel socketChannel) {
        ChannelPipeline channelPipeline = socketChannel.pipeline();
        channelPipeline.addLast(new ChannelHandler[]{new HttpRequestDecoder()});
        channelPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(this.server.maxContentLength())});
        channelPipeline.addLast(new ChannelHandler[]{new HttpResponseEncoder()});
        channelPipeline.addLast(new ChannelHandler[]{this.routerHandler});
        channelPipeline.addLast(new ChannelHandler[]{this.badClientSilencer});
    }
}

