/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MethodRouted<T>
implements ReferenceCounted {
    private final T target;
    private final boolean notFound;
    private final HttpRequest request;
    private final String path;
    private final Map<String, String> pathParams;
    private final Map<String, List<String>> queryParams;
    private final ReferenceCounted requestAsReferenceCounted;

    public MethodRouted(T t, boolean bl, HttpRequest httpRequest, String string, Map<String, String> map, Map<String, List<String>> map2) {
        this.target = t;
        this.notFound = bl;
        this.request = httpRequest;
        this.path = string;
        this.pathParams = map;
        this.queryParams = map2;
        this.requestAsReferenceCounted = httpRequest instanceof ReferenceCounted ? (ReferenceCounted)httpRequest : null;
    }

    public T target() {
        return this.target;
    }

    public boolean notFound() {
        return this.notFound;
    }

    public HttpRequest request() {
        return this.request;
    }

    public String path() {
        return this.path;
    }

    public Map<String, String> pathParams() {
        return this.pathParams;
    }

    public Map<String, List<String>> queryParams() {
        return this.queryParams;
    }

    public String queryParam(String string) {
        List<String> list = this.queryParams.get(string);
        return list == null ? null : list.get(0);
    }

    public String param(String string) {
        String string2 = this.pathParams.get(string);
        return string2 == null ? this.queryParam(string) : string2;
    }

    public List<String> params(String string) {
        String string2;
        List<String> list = this.queryParams.get(string);
        if (list == null) {
            list = new ArrayList<String>();
        }
        if ((string2 = this.pathParams.get(string)) != null) {
            list.add(string2);
        }
        return list;
    }

    public int refCnt() {
        return this.requestAsReferenceCounted == null ? 0 : this.requestAsReferenceCounted.refCnt();
    }

    public boolean release() {
        return this.requestAsReferenceCounted == null ? true : this.requestAsReferenceCounted.release();
    }

    public boolean release(int n) {
        return this.requestAsReferenceCounted == null ? true : this.requestAsReferenceCounted.release(n);
    }

    public ReferenceCounted retain() {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.retain();
        }
        return this;
    }

    public ReferenceCounted retain(int n) {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.retain(n);
        }
        return this;
    }

    public ReferenceCounted touch() {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.touch();
        }
        return this;
    }

    public ReferenceCounted touch(Object object) {
        if (this.requestAsReferenceCounted != null) {
            this.requestAsReferenceCounted.touch(object);
        }
        return this;
    }
}

