/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.router;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.router.DualAbstractHandler;
import io.netty.handler.codec.http.router.Routed;
import io.netty.handler.codec.http.router.Router;
import io.netty.util.concurrent.EventExecutorGroup;

public class Handler
extends DualAbstractHandler<ChannelInboundHandler, Router> {
    public static final String ROUTER_HANDLER_NAME = Handler.class.getName() + "_ROUTER_HANDLER";
    public static final String ROUTED_HANDLER_NAME = Handler.class.getName() + "_ROUTED_HANDLER";
    protected EventExecutorGroup group;

    public Handler(Router router) {
        super(router);
    }

    public Handler group(EventExecutorGroup eventExecutorGroup) {
        this.group = eventExecutorGroup;
        return this;
    }

    public EventExecutorGroup group() {
        return this.group;
    }

    public String name() {
        return ROUTER_HANDLER_NAME;
    }

    @Override
    protected void routed(ChannelHandlerContext channelHandlerContext, Routed routed) throws Exception {
        ChannelPipeline channelPipeline;
        ChannelHandler channelHandler;
        ChannelInboundHandler channelInboundHandler = (ChannelInboundHandler)routed.instanceFromTarget();
        if (channelInboundHandler != (channelHandler = (channelPipeline = channelHandlerContext.pipeline()).get(ROUTED_HANDLER_NAME))) {
            if (channelHandler == null) {
                if (this.group == null) {
                    channelPipeline.addAfter(ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
                } else {
                    channelPipeline.addAfter(this.group, ROUTER_HANDLER_NAME, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
                }
            } else {
                channelPipeline.replace(channelHandler, ROUTED_HANDLER_NAME, (ChannelHandler)channelInboundHandler);
            }
        }
        routed.retain();
        channelHandlerContext.fireChannelRead((Object)routed);
    }
}

